/*
 * Decompiled with CFR 0.152.
 */
package com.github.catalystcode.fortis.speechtotext.telemetry;

import com.github.catalystcode.fortis.speechtotext.utils.ProtocolUtils;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public final class ConnectionTelemetry {
    private static final ConcurrentMap<String, ConnectionTelemetry> POOL = new ConcurrentHashMap<String, ConnectionTelemetry>();
    private String connectionStarted;
    private String connectionEstablished;
    private String connectionErrored;

    private ConnectionTelemetry() {
    }

    public void recordConnectionStarted() {
        if (this.connectionStarted == null) {
            this.connectionStarted = ProtocolUtils.newTimestamp();
        }
    }

    public void recordConnectionEstablished() {
        if (this.connectionEstablished == null) {
            this.connectionEstablished = ProtocolUtils.newTimestamp();
        }
    }

    public void recordConnectionFailed(String string) {
        this.connectionEstablished = ProtocolUtils.newTimestamp();
        this.connectionErrored = string;
    }

    public String getConnectionErrored() {
        return this.connectionErrored;
    }

    public String getConnectionEstablished() {
        return this.connectionEstablished;
    }

    public String getConnectionStarted() {
        return this.connectionStarted;
    }

    public static ConnectionTelemetry forId(String string) {
        ConnectionTelemetry connectionTelemetry;
        ConnectionTelemetry connectionTelemetry2 = (ConnectionTelemetry)POOL.get(string);
        if (connectionTelemetry2 == null && (connectionTelemetry2 = POOL.putIfAbsent(string, connectionTelemetry = new ConnectionTelemetry())) == null) {
            connectionTelemetry2 = connectionTelemetry;
        }
        return connectionTelemetry2;
    }
}

