/*
 * Decompiled with CFR 0.152.
 */
package com.github.catalystcode.fortis.speechtotext.utils;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public final class RiffHeader {
    public static final int RIFF_HEADER_LENGTH = 44;
    private static final int FORMAT_WAVE = 1463899717;
    private static final int CHUNKID_RIFF = 1380533830;
    private static final int SUBCHUNK1ID_FMT = 1718449184;
    private static final int SUBCHUNK2ID_DATA = 1684108385;
    private static final short AUDIO_FORMAT_PCM = 1;
    public final int chunkId;
    public final int chunkSize;
    public final int format;
    public final int subChunk1ID;
    public final int subChunk1Size;
    public final short audioFormat;
    public final short numChannels;
    public final int sampleRate;
    public final int byteRate;
    public final short blockAlign;
    public final short bitsPerSample;
    public final int subChunk2Id;
    public final int subChunk2Size;

    public RiffHeader(byte[] byArray) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray, 0, 44);
        byteBuffer.order(ByteOrder.BIG_ENDIAN);
        this.chunkId = byteBuffer.getInt();
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        this.chunkSize = byteBuffer.getInt();
        byteBuffer.order(ByteOrder.BIG_ENDIAN);
        this.format = byteBuffer.getInt();
        this.subChunk1ID = byteBuffer.getInt();
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        this.subChunk1Size = byteBuffer.getInt();
        this.audioFormat = byteBuffer.getShort();
        this.numChannels = byteBuffer.getShort();
        this.sampleRate = byteBuffer.getInt();
        this.byteRate = byteBuffer.getInt();
        this.blockAlign = byteBuffer.getShort();
        this.bitsPerSample = byteBuffer.getShort();
        byteBuffer.order(ByteOrder.BIG_ENDIAN);
        this.subChunk2Id = byteBuffer.getInt();
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        this.subChunk2Size = byteBuffer.getInt();
    }

    public static void putRiffHeader(ByteBuffer byteBuffer, int n, short s) {
        int n2 = 0;
        int n3 = 16;
        int n4 = 0;
        short s2 = 16;
        int n5 = s2 / 8;
        int n6 = n * s * n5;
        short s3 = (short)(s * n5);
        byteBuffer.order(ByteOrder.BIG_ENDIAN);
        byteBuffer.putInt(1380533830);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        byteBuffer.putInt(n2);
        byteBuffer.order(ByteOrder.BIG_ENDIAN);
        byteBuffer.putInt(1463899717);
        byteBuffer.putInt(1718449184);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        byteBuffer.putInt(n3);
        byteBuffer.putShort((short)1);
        byteBuffer.putShort(s);
        byteBuffer.putInt(n);
        byteBuffer.putInt(n6);
        byteBuffer.putShort(s3);
        byteBuffer.putShort(s2);
        byteBuffer.order(ByteOrder.BIG_ENDIAN);
        byteBuffer.putInt(1684108385);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        byteBuffer.putInt(n4);
    }

    public static RiffHeader fromStream(InputStream inputStream) throws IOException {
        byte[] byArray = new byte[44];
        int n = inputStream.read(byArray);
        if (n != 44) {
            throw new IllegalArgumentException("Unable to read 44 bytes of RIFF header from stream");
        }
        return new RiffHeader(byArray);
    }
}

