/*
 * Decompiled with CFR 0.152.
 */
package com.github.catalystcode.fortis.speechtotext.websocket;

import com.github.catalystcode.fortis.speechtotext.messages.AudioEndMessageCreator;
import com.github.catalystcode.fortis.speechtotext.messages.BinaryMessageCreator;
import com.github.catalystcode.fortis.speechtotext.messages.TextMessageCreator;
import com.github.catalystcode.fortis.speechtotext.telemetry.AudioTelemetry;
import com.github.catalystcode.fortis.speechtotext.telemetry.CallsTelemetry;
import com.github.catalystcode.fortis.speechtotext.telemetry.ConnectionTelemetry;
import com.github.catalystcode.fortis.speechtotext.utils.ProtocolUtils;
import com.github.catalystcode.fortis.speechtotext.utils.RiffHeader;
import com.github.catalystcode.fortis.speechtotext.websocket.PlatformInfo;
import com.github.catalystcode.fortis.speechtotext.websocket.TelemetryInfo;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;
import org.apache.log4j.Logger;

public abstract class MessageSender {
    private static final Logger log = Logger.getLogger(MessageSender.class);
    private final String connectionId;
    private final String requestId;
    private final BinaryMessageCreator binaryMessageCreator;

    protected MessageSender(String string) {
        this.connectionId = string;
        this.requestId = ProtocolUtils.newGuid();
        this.binaryMessageCreator = new BinaryMessageCreator();
    }

    public final void sendConfiguration() {
        String string = new PlatformInfo().toJson();
        String string2 = TextMessageCreator.createTextMessage("speech.config", this.requestId, "application/json; charset=utf-8", string);
        this.sendTextMessage(string2);
        log.info((Object)("Sent speech config: " + string));
    }

    public final void sendAudio(InputStream inputStream) throws IOException, UnsupportedAudioFileException {
        AudioInputStream audioInputStream = MessageSender.adjustAudioEncoding(inputStream);
        this.send16khzMonoPcmAudio(audioInputStream);
    }

    private static AudioInputStream adjustAudioEncoding(InputStream inputStream) throws UnsupportedAudioFileException, IOException {
        AudioInputStream audioInputStream = AudioSystem.getAudioInputStream(inputStream);
        AudioInputStream audioInputStream2 = MessageSender.to16khz(audioInputStream);
        AudioInputStream audioInputStream3 = MessageSender.toMono(audioInputStream2);
        AudioInputStream audioInputStream4 = MessageSender.toPcm(audioInputStream3);
        MessageSender.skipRiffHeader(audioInputStream4);
        return audioInputStream4;
    }

    private static AudioInputStream toPcm(AudioInputStream audioInputStream) {
        AudioFormat audioFormat = audioInputStream.getFormat();
        return AudioSystem.getAudioInputStream(new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, audioFormat.getSampleRate(), audioFormat.getSampleSizeInBits(), audioFormat.getChannels(), audioFormat.getFrameSize(), audioFormat.getFrameRate(), audioFormat.isBigEndian()), audioInputStream);
    }

    private static AudioInputStream toMono(AudioInputStream audioInputStream) {
        AudioFormat audioFormat = audioInputStream.getFormat();
        return AudioSystem.getAudioInputStream(new AudioFormat(audioFormat.getEncoding(), audioFormat.getSampleRate(), audioFormat.getSampleSizeInBits(), 1, audioFormat.getFrameSize(), audioFormat.getFrameRate(), audioFormat.isBigEndian()), audioInputStream);
    }

    private static AudioInputStream to16khz(AudioInputStream audioInputStream) {
        AudioFormat audioFormat = audioInputStream.getFormat();
        return AudioSystem.getAudioInputStream(new AudioFormat(audioFormat.getEncoding(), 16000.0f, audioFormat.getSampleSizeInBits(), audioFormat.getChannels(), audioFormat.getFrameSize(), audioFormat.getFrameRate(), audioFormat.isBigEndian()), audioInputStream);
    }

    private static void skipRiffHeader(InputStream inputStream) throws IOException, UnsupportedAudioFileException {
        RiffHeader.fromStream(inputStream);
    }

    private void send16khzMonoPcmAudio(InputStream inputStream) {
        AudioTelemetry audioTelemetry = AudioTelemetry.forId(this.requestId);
        audioTelemetry.recordAudioStarted();
        try {
            int n;
            byte[] byArray = new byte[8192];
            int n2 = 0;
            while ((n = inputStream.read(byArray)) != -1) {
                ByteBuffer byteBuffer = this.binaryMessageCreator.createBinaryMessage("audio", this.requestId, "audio/wav", byArray, n);
                this.sendBinaryMessage(byteBuffer);
                ++n2;
            }
            log.info((Object)("Sent " + n2 + " audio chunks"));
        }
        catch (Exception exception) {
            audioTelemetry.recordAudioFailed(exception.getMessage());
            throw new RuntimeException(exception);
        }
    }

    public final void sendAudioEnd() {
        AudioTelemetry audioTelemetry = AudioTelemetry.forId(this.requestId);
        ByteBuffer byteBuffer = AudioEndMessageCreator.createAudioEndMessage(this.requestId);
        this.sendBinaryMessage(byteBuffer);
        log.debug((Object)"Sent explicit end-of-audio marker");
        audioTelemetry.recordAudioEnded();
    }

    public final void sendTelemetry() {
        CallsTelemetry callsTelemetry = CallsTelemetry.forId(this.requestId);
        ConnectionTelemetry connectionTelemetry = ConnectionTelemetry.forId(this.connectionId);
        AudioTelemetry audioTelemetry = AudioTelemetry.forId(this.requestId);
        String string = new TelemetryInfo(this.connectionId, callsTelemetry, connectionTelemetry, audioTelemetry).toJson();
        String string2 = TextMessageCreator.createTextMessage("telemetry", this.requestId, "application/json; charset=utf-8", string);
        this.sendTextMessage(string2);
        log.info((Object)("Sent telemetry: " + string));
    }

    protected abstract void sendBinaryMessage(ByteBuffer var1);

    protected abstract void sendTextMessage(String var1);
}

