/*
 * Decompiled with CFR 0.152.
 */
package com.github.catalystcode.fortis.speechtotext.websocket;

import com.github.catalystcode.fortis.speechtotext.telemetry.AudioTelemetry;
import com.github.catalystcode.fortis.speechtotext.telemetry.CallsTelemetry;
import com.github.catalystcode.fortis.speechtotext.telemetry.ConnectionTelemetry;
import java.util.ArrayList;
import java.util.Map;
import java.util.Queue;
import org.json.JSONObject;

class TelemetryInfo {
    private final String connectionId;
    private final CallsTelemetry callsTelemetry;
    private final ConnectionTelemetry connectionTelemetry;
    private final AudioTelemetry audioTelemetry;

    TelemetryInfo(String string, CallsTelemetry callsTelemetry, ConnectionTelemetry connectionTelemetry, AudioTelemetry audioTelemetry) {
        this.connectionId = string;
        this.callsTelemetry = callsTelemetry;
        this.connectionTelemetry = connectionTelemetry;
        this.audioTelemetry = audioTelemetry;
    }

    String toJson() {
        JSONObject jSONObject = new JSONObject();
        this.putReceivedMessages(jSONObject);
        this.putMetrics(jSONObject);
        return jSONObject.toString();
    }

    private void putMetrics(JSONObject jSONObject) {
        ArrayList<JSONObject> arrayList = new ArrayList<JSONObject>();
        arrayList.add(this.createConnectionMetric());
        arrayList.add(this.createMicrophoneMetric());
        jSONObject.put("Metrics", arrayList);
    }

    private void putReceivedMessages(JSONObject jSONObject) {
        ArrayList<JSONObject> arrayList = new ArrayList<JSONObject>();
        for (Map.Entry<String, Queue<String>> entry : this.callsTelemetry.getCallTimestamps().entrySet()) {
            String string = entry.getKey();
            Queue<String> queue = entry.getValue();
            JSONObject jSONObject2 = new JSONObject();
            if (queue.size() > 1) {
                jSONObject2.put(string, queue);
            } else {
                jSONObject2.put(string, (Object)queue.peek());
            }
            arrayList.add(jSONObject2);
        }
        jSONObject.put("ReceivedMessages", arrayList);
    }

    private JSONObject createConnectionMetric() {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("Name", (Object)"Connection");
        jSONObject.put("Id", (Object)this.connectionId);
        jSONObject.put("Start", (Object)this.connectionTelemetry.getConnectionStarted());
        jSONObject.put("End", (Object)this.connectionTelemetry.getConnectionEstablished());
        this.addError(jSONObject, this.connectionTelemetry.getConnectionErrored());
        return jSONObject;
    }

    private JSONObject createMicrophoneMetric() {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("Name", (Object)"Microphone");
        jSONObject.put("Start", (Object)this.audioTelemetry.getAudioStarted());
        jSONObject.put("End", (Object)this.audioTelemetry.getAudioEnded());
        this.addError(jSONObject, this.audioTelemetry.getAudioErrored());
        return jSONObject;
    }

    private void addError(JSONObject jSONObject, String string) {
        if (string != null) {
            jSONObject.put("Error", (Object)string.substring(0, 50));
        }
    }
}

