/*
 * Decompiled with CFR 0.152.
 */
package com.github.catalystcode.fortis.speechtotext.websocket.nv;

import com.github.catalystcode.fortis.speechtotext.config.SpeechServiceConfig;
import com.github.catalystcode.fortis.speechtotext.lifecycle.MessageReceiver;
import com.github.catalystcode.fortis.speechtotext.telemetry.ConnectionTelemetry;
import com.github.catalystcode.fortis.speechtotext.utils.ProtocolUtils;
import com.github.catalystcode.fortis.speechtotext.websocket.MessageSender;
import com.github.catalystcode.fortis.speechtotext.websocket.SpeechServiceClient;
import com.github.catalystcode.fortis.speechtotext.websocket.nv.NvMessageReceiver;
import com.github.catalystcode.fortis.speechtotext.websocket.nv.NvMessageSender;
import com.neovisionaries.ws.client.WebSocket;
import com.neovisionaries.ws.client.WebSocketFactory;
import com.neovisionaries.ws.client.WebSocketListener;
import java.util.concurrent.CountDownLatch;

public class NvSpeechServiceClient
implements SpeechServiceClient {
    private final CountDownLatch socketCloseLatch = new CountDownLatch(1);
    private WebSocket webSocket;

    @Override
    public MessageSender start(SpeechServiceConfig speechServiceConfig, MessageReceiver messageReceiver) throws Exception {
        String string = ProtocolUtils.newGuid();
        ConnectionTelemetry connectionTelemetry = ConnectionTelemetry.forId(string);
        WebSocketFactory webSocketFactory = new WebSocketFactory();
        this.webSocket = webSocketFactory.createSocket(speechServiceConfig.getConnectionUrl(string));
        this.webSocket.addListener((WebSocketListener)new NvMessageReceiver(this.socketCloseLatch, messageReceiver, connectionTelemetry));
        connectionTelemetry.recordConnectionStarted();
        this.webSocket.connect();
        return new NvMessageSender(string, this.webSocket);
    }

    @Override
    public void stop() {
        this.webSocket.disconnect();
    }

    @Override
    public void awaitEnd() throws InterruptedException {
        this.socketCloseLatch.await();
    }

    @Override
    public CountDownLatch getEndLatch() {
        return this.socketCloseLatch;
    }
}

