/*
 * Decompiled with CFR 0.152.
 */
package com.github.cpprofiler;

import com.github.cpprofiler.Message;
import java.io.IOException;
import java.net.Socket;

public class Connector {
    private Socket clientSocket;
    private boolean _connected = false;

    public Connector() {
        System.out.println("Connector initialized v1.2.0");
    }

    public void connect(int port) {
        try {
            this.clientSocket = new Socket("localhost", port);
            this._connected = true;
        }
        catch (IOException e) {
            System.err.println("couldn't connect to profiler; running solo");
        }
    }

    public void disconnect() {
        if (!this._connected) {
            return;
        }
        Message.Node msg = Message.Node.newBuilder().setType(Message.Node.MsgType.DONE).build();
        this.sendOverSocket(msg);
        try {
            this.clientSocket.close();
        }
        catch (IOException e) {
            System.err.println("Caught IOException 2: " + e.getMessage());
        }
    }

    public ExtendedNode createNode(int sid, int pid, int alt, int kids, NodeStatus status) {
        ExtendedNode node = new ExtendedNode(this, sid, pid, alt, kids, status);
        return node;
    }

    public void sendNode(int sid, int pid, int alt, int kids, NodeStatus status, String label, String info) {
        if (!this._connected) {
            return;
        }
        Message.Node node = Message.Node.newBuilder().setType(Message.Node.MsgType.NODE).setSid(sid).setPid(pid).setAlt(alt).setKids(kids).setStatus(Message.Node.NodeStatus.valueOf(status.getNumber())).setLabel(label).setInfo(info).build();
        this.sendOverSocket(node);
    }

    public void restart(int rid) {
        this.restart("", rid);
    }

    public void restart(String file_name) {
        this.restart(file_name, -1);
    }

    private void restart(String file_name, int rid) {
        if (!this._connected) {
            return;
        }
        Message.Node msg = Message.Node.newBuilder().setType(Message.Node.MsgType.START).setLabel(file_name).setRestartId(rid).build();
        this.sendOverSocket(msg);
    }

    public void done() {
        Message.Node msg = Message.Node.newBuilder().setType(Message.Node.MsgType.DONE).build();
        this.sendOverSocket(msg);
    }

    private void sendOverSocket(Message.Node msg) {
        if (!this._connected) {
            return;
        }
        try {
            byte[] b = msg.toByteArray();
            int size = b.length;
            byte[] size_buffer = new byte[4];
            for (int i = 0; i < 4; ++i) {
                size_buffer[i] = (byte)(size >>> i * 8);
            }
            this.clientSocket.getOutputStream().write(size_buffer);
            this.clientSocket.getOutputStream().write(b);
        }
        catch (IOException e) {
            System.err.println("Caught IOException 3: " + e.getMessage());
        }
    }

    public class ExtendedNode {
        Message.Node.Builder builder = Message.Node.newBuilder();
        Connector _connector;

        public ExtendedNode(Connector connector, int sid, int pid, int alt, int kids, NodeStatus status) {
            this.builder.setType(Message.Node.MsgType.NODE).setSid(sid).setPid(pid).setAlt(alt).setKids(kids).setStatus(Message.Node.NodeStatus.valueOf(status.getNumber()));
            this._connector = connector;
        }

        public ExtendedNode setLabel(String label) {
            this.builder.setLabel(label);
            return this;
        }

        public ExtendedNode setInfo(String info) {
            this.builder.setInfo(info);
            return this;
        }

        public ExtendedNode setRestartId(int restart_id) {
            this.builder.setRestartId(restart_id);
            return this;
        }

        public ExtendedNode setThreadId(int thread_id) {
            this.builder.setThreadId(thread_id);
            return this;
        }

        public void send() {
            Message.Node msg = this.builder.build();
            this._connector.sendOverSocket(msg);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum NodeStatus {
        SOLVED(0),
        FAILED(1),
        BRANCH(2),
        SKIPPED(6);

        private final int id;

        private NodeStatus(int id) {
            this.id = id;
        }

        public int getNumber() {
            return this.id;
        }
    }
}

