/*
 * Decompiled with CFR 0.152.
 */
package com.github.ddm4j.api.document.utils;

import com.github.ddm4j.api.document.bean.ParamBaseVo;
import com.github.ddm4j.api.document.bean.ParamChildrenVo;
import com.github.ddm4j.api.document.common.model.FieldType;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Date;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FieldUtil {
    public static Type extractGenType(Type type, Type genType, FieldType ct) {
        if (null == type) {
            return null;
        }
        switch (ct) {
            case T: 
            case ArrayT: 
            case ClassT: {
                if (type instanceof ParameterizedType) {
                    ParameterizedType pt = (ParameterizedType)type;
                    if (null == pt.getActualTypeArguments() || pt.getActualTypeArguments().length < 1) break;
                    Type t1 = pt.getActualTypeArguments()[0];
                    if (t1 instanceof Class) {
                        if ((Class)t1 == Object.class) {
                            return null;
                        }
                        return t1;
                    }
                    if (t1 instanceof ParameterizedType) {
                        return t1;
                    }
                    if (null != genType) {
                        if (genType instanceof Class) {
                            return (Class)genType;
                        }
                        if (genType instanceof ParameterizedType) {
                            pt = (ParameterizedType)genType;
                            if (null == pt.getOwnerType()) {
                                return pt.getRawType();
                            }
                            return pt.getActualTypeArguments()[0];
                        }
                    }
                    return genType;
                }
                if (!(genType instanceof ParameterizedType)) break;
                ParameterizedType pt = (ParameterizedType)genType;
                if (null != pt.getActualTypeArguments() && pt.getActualTypeArguments().length >= 1) {
                    return pt.getActualTypeArguments()[0];
                }
                return null;
            }
            case ArrayClassT: {
                GenericArrayType gat = (GenericArrayType)type;
                ParameterizedType pt = (ParameterizedType)gat.getGenericComponentType();
                pt = (ParameterizedType)pt.getRawType();
                if (null != pt.getActualTypeArguments() && pt.getActualTypeArguments().length >= 1) {
                    Type t1 = pt.getActualTypeArguments()[0];
                    if (t1 instanceof Class) {
                        if ((Class)t1 == Object.class) {
                            return null;
                        }
                        return t1;
                    }
                    return null;
                }
                return null;
            }
            default: {
                return null;
            }
        }
        return null;
    }

    public static Class<?> extractClassByType(Type type, Type genType, FieldType ct) {
        Class cla = null;
        if (FieldType.Clazz == ct) {
            cla = (Class)type;
        } else if (FieldType.ArrayClass == ct) {
            cla = (Class)type;
            cla = cla.getComponentType();
        } else if (FieldType.ArrayClassT == ct) {
            GenericArrayType gat = (GenericArrayType)type;
            ParameterizedType pt = (ParameterizedType)gat.getGenericComponentType();
            cla = (Class)pt.getRawType();
        } else if (FieldType.ClassT == ct) {
            if (type instanceof ParameterizedType) {
                ParameterizedType pt = (ParameterizedType)type;
                Type t1 = pt.getActualTypeArguments()[0];
                if (t1 instanceof Class) {
                    if ((Class)t1 == Object.class) {
                        return null;
                    }
                    return (Class)t1;
                }
                return null;
            }
            if (genType instanceof ParameterizedType) {
                ParameterizedType pt = (ParameterizedType)genType;
                cla = (Class)pt.getActualTypeArguments()[0];
            }
        } else if (FieldType.T == ct) {
            if (null != genType) {
                if (genType instanceof Class) {
                    return (Class)genType;
                }
                if (genType instanceof ParameterizedType) {
                    ParameterizedType pt = (ParameterizedType)genType;
                    return (Class)pt.getRawType();
                }
                if (genType.getTypeName().equals("?")) {
                    return null;
                }
                return (Class)genType;
            }
        } else if (FieldType.ArrayT == ct && null != genType) {
            if (genType instanceof Class) {
                return (Class)genType;
            }
            if (genType instanceof ParameterizedType) {
                ParameterizedType pt = (ParameterizedType)genType;
                if (null == pt.getOwnerType()) {
                    return (Class)pt.getRawType();
                }
                cla = (Class)pt.getActualTypeArguments()[0];
            }
        }
        return cla;
    }

    public static <T extends ParamChildrenVo<?>> void removeField(List<T> vos, String field) {
        String[] keys = field.split("\\.");
        List<T> tempChildren = vos;
        block0: for (int i = 0; i < keys.length; ++i) {
            String key = keys[i];
            for (int j = 0; j < tempChildren.size(); ++j) {
                if (!((ParamChildrenVo)tempChildren.get(j)).getField().equals(key)) continue;
                if (i == keys.length - 1) {
                    tempChildren.remove(j);
                    return;
                }
                tempChildren = ((ParamChildrenVo)tempChildren.get(j)).getChildren();
                continue block0;
            }
        }
    }

    public static <T extends ParamBaseVo> boolean isDuplicate(List<T> vos, ParamBaseVo vo) {
        if (null != vos && vos.size() > 0 && null != vo) {
            for (int i = 0; i < vos.size(); ++i) {
                if (!((ParamBaseVo)vos.get(i)).getField().equals(vo.getField())) continue;
                return true;
            }
        }
        return false;
    }

    public static FieldType checkFieldType(Type type) {
        if (type instanceof ParameterizedType) {
            return FieldType.ClassT;
        }
        if (type instanceof GenericArrayType) {
            GenericArrayType gat = (GenericArrayType)type;
            if (gat.getGenericComponentType() instanceof ParameterizedType) {
                return FieldType.ArrayClassT;
            }
            return FieldType.ArrayT;
        }
        if (type instanceof Class) {
            if (((Class)type).isArray()) {
                return FieldType.ArrayClass;
            }
            return FieldType.Clazz;
        }
        return FieldType.T;
    }

    public static int checkBaseClass(Class<?> cla) {
        if (null == cla) {
            return -2;
        }
        if (Number.class.isAssignableFrom(cla)) {
            return 1;
        }
        if (String.class.isAssignableFrom(cla)) {
            return 2;
        }
        if (Enum.class.isAssignableFrom(cla)) {
            return 3;
        }
        if (List.class.isAssignableFrom(cla)) {
            return 4;
        }
        if (Set.class.isAssignableFrom(cla)) {
            return 6;
        }
        if (Date.class.isAssignableFrom(cla)) {
            return 7;
        }
        if (cla.isInterface()) {
            return 0;
        }
        return -1;
    }

    public static boolean isEmpty(String str) {
        return null == str || "".equals(str.trim());
    }
}

