/*
 * Decompiled with CFR 0.152.
 */
package com.github.ddm4j.api.document.utils;

import com.github.ddm4j.api.document.annotation.ApiField;
import com.github.ddm4j.api.document.annotation.ApiIgnore;
import com.github.ddm4j.api.document.annotation.ApiResponse;
import com.github.ddm4j.api.document.annotation.ApiResponseIgnore;
import com.github.ddm4j.api.document.annotation.ApiResponses;
import com.github.ddm4j.api.document.bean.ParamBaseVo;
import com.github.ddm4j.api.document.bean.ResponseVo;
import com.github.ddm4j.api.document.common.model.FieldType;
import com.github.ddm4j.api.document.utils.FieldUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodResponseUtil {
    public List<ResponseVo> getResponseVo(Method method) {
        List<ResponseVo> list;
        ApiResponses response = method.getAnnotation(ApiResponses.class);
        Type genType = method.getGenericReturnType();
        if (null != genType) {
            FieldType type = FieldUtil.checkFieldType(genType);
            genType = FieldUtil.extractGenType(genType, null, type);
        }
        if (null == (list = this.getResponseFields(method.getReturnType(), genType))) {
            return list;
        }
        ApiResponseIgnore hides = method.getAnnotation(ApiResponseIgnore.class);
        if (null != hides && null != hides.value() && hides.value().length > 0) {
            for (String field : hides.value()) {
                FieldUtil.removeField(list, field);
            }
        }
        if (null != response && response.value().length > 0) {
            for (ApiResponse param : response.value()) {
                this.replaceResponseField(param, list);
            }
        }
        return list;
    }

    private void replaceResponseField(ApiResponse param, List<ResponseVo> list) {
        String[] keys = param.field().split("\\.");
        ParamBaseVo tempVo = null;
        List<ResponseVo> tempChildren = list;
        block0: for (String key : keys) {
            for (ResponseVo vo : tempChildren) {
                if (!vo.getField().equals(key)) continue;
                tempVo = vo;
                tempChildren = vo.getChildren();
                continue block0;
            }
        }
        if (tempVo != null) {
            tempVo.setRequired(param.required());
            if (!FieldUtil.isEmpty(param.describe())) {
                tempVo.setDescribe(param.describe());
            }
        }
    }

    private List<ResponseVo> getResponseFields(Class<?> cla, Type genType) {
        List<ResponseVo> list2;
        if (null == cla) {
            return null;
        }
        ArrayList<ResponseVo> list = new ArrayList<ResponseVo>();
        Field[] fis = cla.getDeclaredFields();
        if (null == fis || fis.length == 0) {
            return null;
        }
        for (Field field : fis) {
            ApiIgnore ignore = field.getAnnotation(ApiIgnore.class);
            if (null != ignore || Modifier.isFinal(field.getModifiers()) || Modifier.isStatic(field.getModifiers())) continue;
            FieldType type = FieldUtil.checkFieldType(field.getGenericType());
            ResponseVo vo = null;
            Class<?> cla2 = null;
            switch (type) {
                case Clazz: {
                    vo = this.getResponseFieldInfo(field, field.getType(), false, null, type);
                    break;
                }
                case ArrayClass: {
                    cla2 = FieldUtil.extractClassByType(field.getGenericType(), null, type);
                    vo = this.getResponseFieldInfo(field, cla2, true, null, type);
                    break;
                }
                case ClassT: {
                    if (List.class.isAssignableFrom(field.getType()) || Set.class.isAssignableFrom(cla)) {
                        Class<?> gen = FieldUtil.extractClassByType(field.getGenericType(), genType, type);
                        if (null == gen) {
                            type = FieldUtil.checkFieldType(genType);
                            gen = FieldUtil.extractClassByType(genType, genType, type);
                        }
                        if (null == gen) break;
                        cla2 = gen;
                        vo = this.getResponseFieldInfo(field, cla2, true, null, type);
                        break;
                    }
                    cla2 = field.getType();
                    vo = this.getResponseFieldInfo(field, cla2, false, genType, type);
                    break;
                }
                case ArrayClassT: {
                    vo = this.getResponseFieldInfo(field, field.getType(), false, genType, type);
                    break;
                }
                case T: {
                    if (null == genType) break;
                    cla2 = FieldUtil.extractClassByType(field.getGenericType(), genType, type);
                    vo = this.getResponseFieldInfo(field, cla2, false, genType, type);
                    break;
                }
                case ArrayT: {
                    if (null == genType) break;
                    cla2 = FieldUtil.extractClassByType(field.getGenericType(), genType, type);
                    type = FieldType.T;
                    vo = this.getResponseFieldInfo(field, cla2, true, genType, type);
                }
            }
            if (null == vo) continue;
            list.add(vo);
        }
        if (Object.class != cla.getSuperclass() && !cla.getSuperclass().isInterface() && null != (list2 = this.getResponseFields(cla.getSuperclass(), genType))) {
            for (ResponseVo field : list2) {
                list.add(field);
            }
        }
        return list;
    }

    private ResponseVo getResponseFieldInfo(Field field, Class<?> cla2, boolean array, Type genType, FieldType type) {
        ApiField apiField = field.getAnnotation(ApiField.class);
        if (null != apiField && apiField.hide()) {
            return null;
        }
        ResponseVo vo = new ResponseVo();
        if (null != apiField) {
            vo.setDescribe(apiField.value());
        }
        vo.setField(field.getName());
        switch (FieldUtil.checkBaseClass(cla2)) {
            case -2: {
                return null;
            }
            case 1: {
                if (array) {
                    vo.setType("Array<Number>");
                    break;
                }
                vo.setType("Number");
                break;
            }
            case 2: {
                if (array) {
                    vo.setType("Array<String>");
                    break;
                }
                vo.setType("String");
                break;
            }
            case 3: {
                if (array) {
                    vo.setType("Array<Enum/Number>");
                    break;
                }
                vo.setType("Enum/Number");
                break;
            }
            case 0: {
                if (array) {
                    vo.setType("Array<Other>");
                    break;
                }
                vo.setType("Other");
                break;
            }
            case 7: {
                if (array) {
                    vo.setType("Array<Date>");
                    break;
                }
                vo.setType("Date");
                break;
            }
            default: {
                if (array) {
                    vo.setType("Array<Object>");
                } else {
                    vo.setType("Object");
                }
                switch (type) {
                    case ClassT: 
                    case ArrayClassT: 
                    case T: 
                    case ArrayT: {
                        genType = FieldUtil.extractGenType(field.getGenericType(), genType, type);
                        break;
                    }
                    case Clazz: 
                    case ArrayClass: {
                        genType = null;
                    }
                }
                List<ResponseVo> children = null;
                switch (type) {
                    case Clazz: {
                        children = this.getResponseFields(cla2, genType);
                        break;
                    }
                    case ArrayClass: {
                        cla2 = FieldUtil.extractClassByType(field.getGenericType(), genType, type);
                        if (null == cla2) break;
                        children = this.getResponseFields(cla2, genType);
                        break;
                    }
                    case T: 
                    case ArrayT: {
                        if (null == cla2) break;
                        children = this.getResponseFields(cla2, genType);
                        break;
                    }
                    default: {
                        children = this.getResponseFields(cla2, genType);
                    }
                }
                if (null == children) break;
                vo.setChildren(children);
            }
        }
        return vo;
    }
}

