/*
 * Decompiled with CFR 0.152.
 */
package com.github.ddm4j.api.document.check;

import com.github.ddm4j.api.document.annotation.ApiIgnore;
import com.github.ddm4j.api.document.annotation.ApiParam;
import com.github.ddm4j.api.document.annotation.ApiParams;
import com.github.ddm4j.api.document.common.exception.ApiCheckError;
import com.github.ddm4j.api.document.common.exception.ApiCheckException;
import com.github.ddm4j.api.document.common.exception.bean.ApiCheckInfo;
import com.github.ddm4j.api.document.config.CheckConfig;
import com.github.ddm4j.api.document.config.bean.MessageBean;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.LocalVariableTableParameterNameDiscoverer;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.RequestHeader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Aspect
@Component
public class ApiParamCheck {
    @Autowired
    CheckConfig config;
    static Logger logger = LoggerFactory.getLogger(ApiParamCheck.class);

    @Before(value="execution(public * *(..)) && @annotation(apiParams)")
    public void checkParam(JoinPoint jp, ApiParams apiParams) throws Exception {
        if (null == this.config || !this.config.isEnable()) {
            return;
        }
        ApiParam[] params = apiParams.value();
        if (null == params || params.length == 0) {
            return;
        }
        if (null == jp.getArgs() || jp.getArgs().length == 0) {
            logger.error("\u672a\u6ca1\u53c2\u6570\uff0c\u4e0d\u8fdb\u884c\u6821\u9a8c");
            return;
        }
        MethodSignature signature = (MethodSignature)jp.getSignature();
        LocalVariableTableParameterNameDiscoverer u = new LocalVariableTableParameterNameDiscoverer();
        String[] names = u.getParameterNames(signature.getMethod());
        Annotation[][] parameterAnnotations = signature.getMethod().getParameterAnnotations();
        HashMap<String, Object> paramObjs = new HashMap<String, Object>();
        for (int i = 0; i < parameterAnnotations.length; ++i) {
            boolean ignore = false;
            String name = names[i];
            for (Annotation annotation : parameterAnnotations[i]) {
                if (annotation instanceof ApiIgnore) {
                    ignore = true;
                    break;
                }
                if (!(annotation instanceof RequestHeader)) continue;
                RequestHeader rh = (RequestHeader)annotation;
                if (!ApiParamCheck.isEmpty(rh.value())) {
                    name = rh.value();
                    continue;
                }
                if (ApiParamCheck.isEmpty(rh.name())) continue;
                name = rh.name();
            }
            if (ignore) continue;
            Object obj = jp.getArgs()[i];
            paramObjs.put(name, obj);
        }
        this.checkParam(paramObjs, names, params);
    }

    public void checkParam(Map<String, Object> params, String[] names, ApiParam[] apiParams) throws Exception, Exception {
        ArrayList<ApiCheckInfo> infos = new ArrayList<ApiCheckInfo>();
        for (ApiParam apiParam : apiParams) {
            boolean empty = true;
            for (Map.Entry<String, Object> param : params.entrySet()) {
                ApiCheckInfo info;
                String key;
                ApiCheckInfo info2;
                MessageBean message;
                if (null == param.getValue()) {
                    if (!apiParam.field().equals(param.getKey())) continue;
                    empty = false;
                    message = this.getMessage(apiParam);
                    info2 = this.checkValue(param.getValue(), apiParam, message);
                    if (null == info2) continue;
                    infos.add(info2);
                    continue;
                }
                if (param.getValue().getClass().isInterface() || Number.class.isAssignableFrom(param.getValue().getClass()) || param.getValue().getClass() == String.class) {
                    if (!apiParam.field().equals(param.getKey())) continue;
                    empty = false;
                    message = this.getMessage(apiParam);
                    info2 = this.checkValue(param.getValue(), apiParam, message);
                    if (null == info2) continue;
                    infos.add(info2);
                    continue;
                }
                String[] keys = apiParam.field().split("\\.");
                Field field = null;
                Class<?> cla = param.getValue().getClass();
                Object value = param.getValue();
                boolean array = false;
                for (int i = 0; i < keys.length && null != (field = ApiParamCheck.getField(cla, key = keys[i])); ++i) {
                    if (i >= keys.length - 1) continue;
                    field.setAccessible(true);
                    value = field.get(value);
                    cla = value.getClass();
                    if (!value.getClass().isArray() && !List.class.isAssignableFrom(value.getClass()) && !Set.class.isAssignableFrom(value.getClass())) continue;
                    empty = false;
                    array = true;
                    MessageBean message2 = this.getMessage(apiParam);
                    ApiCheckInfo info3 = this.checkParamArray(value, keys, i, apiParam, message2);
                    if (null == info3) break;
                    infos.add(info3);
                    break;
                }
                if (array) continue;
                if (null != field) {
                    MessageBean message3;
                    empty = false;
                    field.setAccessible(true);
                    info = this.checkValue(value = field.get(value), apiParam, message3 = this.getMessage(apiParam));
                    if (null == info) continue;
                    infos.add(info);
                    continue;
                }
                if (!param.getKey().trim().equals(apiParam.field().trim())) continue;
                empty = false;
                MessageBean message4 = this.getMessage(apiParam);
                info = this.checkValue(param.getValue(), apiParam, message4);
                if (null == info) continue;
                infos.add(info);
            }
            if (empty && apiParam.required()) {
                logger.error("\u672a\u627e\u5230 field:" + apiParam.field());
                MessageBean message = this.getMessage(apiParam);
                infos.add(this.getCheckInfo(apiParam, ApiCheckError.EMPTY, message.getRequired()));
            } else if (empty) {
                logger.error("\u672a\u627efield:" + apiParam.field() + "  \u8df3\u8fc7\u6821\u9a8c");
            }
            if (null == infos || infos.size() <= 0 || this.config.isAll()) continue;
            throw new ApiCheckException(infos);
        }
        if (null != infos && infos.size() > 0) {
            throw new ApiCheckException(infos);
        }
    }

    private ApiCheckInfo checkParamArray(Object value, String[] keys, int index, ApiParam apiParam, MessageBean message) throws Exception {
        if (value.getClass().isArray()) {
            Object[] objs;
            for (Object obj : objs = (Object[])value) {
                ApiCheckInfo info = this.checkFieldArrayValue(obj, keys, index, apiParam, message, obj);
                if (null == info) continue;
                return info;
            }
        } else if (List.class.isAssignableFrom(value.getClass())) {
            List objs = (List)value;
            for (Object obj : objs) {
                ApiCheckInfo info = this.checkFieldArrayValue(obj, keys, index, apiParam, message, obj);
                if (null == info) continue;
                return info;
            }
        } else {
            Set objs = (Set)value;
            for (Object obj : objs) {
                ApiCheckInfo info = this.checkFieldArrayValue(obj, keys, index, apiParam, message, obj);
                if (null == info) continue;
                return info;
            }
        }
        return null;
    }

    private ApiCheckInfo checkFieldArrayValue(Object value, String[] keys, int index, ApiParam apiParam, MessageBean message, Object obj) throws IllegalAccessException, Exception {
        ApiCheckInfo info;
        Object value2 = value;
        Field field = null;
        for (int i = index + 1; i < keys.length; ++i) {
            field = ApiParamCheck.getField(obj.getClass(), keys[i]);
            if (null == field || i >= keys.length - 1) continue;
            field.setAccessible(true);
            value2 = field.get(obj);
            if (!value2.getClass().isArray() && !List.class.isAssignableFrom(value2.getClass()) && !Set.class.isAssignableFrom(value2.getClass())) continue;
            info = this.checkParamArray(value2, keys, i, apiParam, message);
            if (null != info) {
                return info;
            }
            field = null;
        }
        if (null != field) {
            field.setAccessible(true);
            Object v = field.get(value2);
            info = this.checkValue(v, apiParam, message);
            if (null != info) {
                return info;
            }
        }
        return null;
    }

    private ApiCheckInfo checkValue(Object value, ApiParam apiParam, MessageBean bean) {
        String regexp;
        if (null == value) {
            if (apiParam.required()) {
                return this.getCheckInfo(apiParam, ApiCheckError.EMPTY, bean.getRequired());
            }
            return null;
        }
        if (value.getClass().isInterface()) {
            if (apiParam.required()) {
                return this.getCheckInfo(apiParam, ApiCheckError.EMPTY, bean.getRequired());
            }
        } else if (Number.class.isAssignableFrom(value.getClass())) {
            Double dou = Double.parseDouble(value.toString());
            if (dou < (double)apiParam.min()) {
                return this.getCheckInfo(apiParam, ApiCheckError.MIN, bean.getMin());
            }
            if (dou > (double)apiParam.max()) {
                return this.getCheckInfo(apiParam, ApiCheckError.MAX, bean.getMax());
            }
            String regexp2 = this.getRegexp(apiParam.regexp());
            if (!ApiParamCheck.isEmpty(regexp2) && !value.toString().matches(regexp2)) {
                return this.getCheckInfo(apiParam, ApiCheckError.REGEXP, bean.getRegexp());
            }
        } else if (value.getClass() == String.class) {
            String str = value.toString().trim();
            if (str.length() < apiParam.min()) {
                return this.getCheckInfo(apiParam, ApiCheckError.MIN, bean.getMin());
            }
            if (str.length() > apiParam.max()) {
                return this.getCheckInfo(apiParam, ApiCheckError.MAX, bean.getMax());
            }
            String regexp3 = this.getRegexp(apiParam.regexp());
            if (!ApiParamCheck.isEmpty(regexp3) && !str.matches(regexp3)) {
                return this.getCheckInfo(apiParam, ApiCheckError.REGEXP, bean.getRegexp());
            }
        } else if (List.class.isAssignableFrom(value.getClass())) {
            List values = (List)value;
            for (Object obj : values) {
                ApiCheckInfo info = this.checkValue(obj, apiParam, bean);
                if (null == info) continue;
                return info;
            }
        } else if (Set.class.isAssignableFrom(value.getClass())) {
            Set values = (Set)value;
            for (Object obj : values) {
                ApiCheckInfo info = this.checkValue(obj, apiParam, bean);
                if (null == info) continue;
                return info;
            }
        } else if (value.getClass().isArray()) {
            Object[] values;
            for (Object obj : values = (Object[])value) {
                ApiCheckInfo info = this.checkValue(obj, apiParam, bean);
                if (null == info) continue;
                return info;
            }
        } else if (Date.class.isAssignableFrom(value.getClass()) && !ApiParamCheck.isEmpty(regexp = this.getRegexp(apiParam.regexp()))) {
            SimpleDateFormat sdf = null;
            String key = apiParam.regexp();
            key = key.startsWith("${") && key.endsWith("}") && key.length() > 3 ? key.substring(2, key.length() - 1) : (ApiParamCheck.isEmpty(this.config.getDateFormat()) ? "default" : "custom");
            try {
                sdf = "custom".equals(key) ? new SimpleDateFormat(this.config.getDateFormat()) : (key.startsWith("default") ? new SimpleDateFormat("yyyy-MM-dd HH:mm:ss") : (key.startsWith("time") ? (key.endsWith("Hm") ? new SimpleDateFormat("HH:mm") : (key.endsWith("ms") ? new SimpleDateFormat("mm:ss") : new SimpleDateFormat("HH:mm:ss"))) : (key.startsWith("dateTime") ? (key.endsWith("Hm") ? new SimpleDateFormat("yyyy-MM-dd HH:mm") : (key.endsWith("H") ? new SimpleDateFormat("yyyy-MM-dd HH") : new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"))) : (key.endsWith("M") ? new SimpleDateFormat("yyyy-MM") : (key.endsWith("Md") ? new SimpleDateFormat("MM-dd") : new SimpleDateFormat("yyyy-MM-dd"))))));
                Date date = (Date)value;
                String str = sdf.format(date);
                if (!str.matches(regexp)) {
                    return this.getCheckInfo(apiParam, ApiCheckError.REGEXP, bean.getRegexp());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private String getRegexp(String regexp) {
        if (ApiParamCheck.isEmpty(regexp)) {
            return null;
        }
        if (regexp.startsWith("${") && regexp.endsWith("}")) {
            String key = regexp.substring(2, regexp.length() - 1);
            String reg = this.config.getRegexps().get(key);
            if (ApiParamCheck.isEmpty(reg)) {
                logger.error("\u53c2\u6570\u6821\u9a8c\uff1a" + regexp + " \u6b63\u5219\u8868\u8fbe\u5f0f,\u4e0d\u5b58\u5728");
                return null;
            }
            return reg;
        }
        return regexp;
    }

    private MessageBean getMessage(ApiParam apiParam) {
        MessageBean bean = null;
        if (!ApiParamCheck.isEmpty(apiParam.message())) {
            String key = apiParam.message();
            if (key.startsWith("${") && key.endsWith("}")) {
                key = key.length() <= 3 ? "default" : key.substring(2, key.length() - 1);
            }
            bean = this.config.getMessages().get(apiParam.message());
        }
        if (null == bean) {
            bean = this.config.getMessages().get("default");
        }
        return bean;
    }

    private ApiCheckInfo getCheckInfo(ApiParam apiParam, ApiCheckError error, String message) {
        ApiCheckInfo info = new ApiCheckInfo();
        info.setDescribe(apiParam.describe());
        info.setError(error);
        info.setField(apiParam.field());
        info.setMessage(message);
        return info;
    }

    public static Field getField(Class<?> cla, String key) {
        Field field = null;
        try {
            field = cla.getDeclaredField(key);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        if (null == field && Object.class != cla.getSuperclass()) {
            return ApiParamCheck.getField(cla.getSuperclass(), key);
        }
        return field;
    }

    public static boolean isEmpty(String str) {
        return null == str || "".equals(str.trim());
    }
}

