/*
 * Decompiled with CFR 0.152.
 */
package com.github.ddm4j.api.document.controller;

import com.github.ddm4j.api.document.bean.InterfaceJsonDoc;
import com.github.ddm4j.api.document.config.CheckConfig;
import com.github.ddm4j.api.document.config.DocumentConfig;
import com.github.ddm4j.api.document.utils.ScanControllerUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class ApiDocumentController {
    @Autowired
    DocumentConfig config;
    @Autowired
    CheckConfig chConfig;

    @ResponseBody
    @RequestMapping(value={"/ddm4j/document"})
    public InterfaceJsonDoc document(String account, String password) {
        InterfaceJsonDoc doc = new InterfaceJsonDoc();
        doc.setName(this.config.getName());
        doc.setDescribe(this.config.getDescribe());
        doc.setVersion(this.config.getVersion());
        if (!this.config.isEnable()) {
            doc.setCode(1001);
            return doc;
        }
        if (null == this.config.getPath() || "".equals(this.config.getPath().trim())) {
            doc.setCode(1001);
            return doc;
        }
        if (this.config.getLogin().isEnable()) {
            doc.setCode(2001);
            if (null != this.config.getLogin().getAccount() && !"".equals(this.config.getLogin().getAccount().trim())) {
                if (null == account || "".equals(account.trim())) {
                    doc.setCode(3001);
                    return doc;
                }
                if (!account.trim().equals(this.config.getLogin().getAccount().trim())) {
                    return doc;
                }
            }
            if (null != this.config.getLogin().getPassword() && !"".equals(this.config.getLogin().getPassword().trim())) {
                if (null == password || "".equals(password.trim())) {
                    doc.setCode(3001);
                    return doc;
                }
                if (!password.trim().equals(this.config.getLogin().getPassword().trim())) {
                    return doc;
                }
            }
        }
        doc.setCode(1000);
        String path = this.config.getContextPath();
        if (null != path && !"".equals(path)) {
            if (!path.startsWith("/")) {
                path = "/" + path;
            }
            if (path.endsWith("/") && path.length() > 2) {
                path = path.substring(0, path.length() - 1);
            }
        }
        ScanControllerUtil util = new ScanControllerUtil(this.chConfig, this.config);
        doc.setControllers(util.scan(this.config.getPath(), path));
        return doc;
    }
}

