/*
 * Decompiled with CFR 0.152.
 */
package com.github.ddm4j.api.document.utils;

import com.github.ddm4j.api.document.annotation.ApiField;
import com.github.ddm4j.api.document.annotation.ApiIgnore;
import com.github.ddm4j.api.document.annotation.ApiMethod;
import com.github.ddm4j.api.document.annotation.ApiParam;
import com.github.ddm4j.api.document.annotation.ApiParamIgnore;
import com.github.ddm4j.api.document.annotation.ApiParams;
import com.github.ddm4j.api.document.bean.HeadVo;
import com.github.ddm4j.api.document.bean.InterfaceVo;
import com.github.ddm4j.api.document.bean.ParamBaseVo;
import com.github.ddm4j.api.document.bean.ParameterVo;
import com.github.ddm4j.api.document.common.model.FieldType;
import com.github.ddm4j.api.document.common.model.KVEntity;
import com.github.ddm4j.api.document.config.CheckConfig;
import com.github.ddm4j.api.document.utils.FieldUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.springframework.core.LocalVariableTableParameterNameDiscoverer;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.multipart.MultipartFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodRequestUtil {
    private CheckConfig config;
    private boolean json = false;

    public MethodRequestUtil(CheckConfig config) {
        this.config = config;
    }

    public InterfaceVo getRequestVo(Method method, String methodType) {
        this.json = false;
        InterfaceVo ivo = this.extractUriAndType(method, methodType);
        if (null == ivo) {
            return null;
        }
        ApiMethod am = method.getAnnotation(ApiMethod.class);
        if (null == am) {
            ivo.setName(method.getName());
            ivo.setVersion("V1.0");
        }
        if (null != am) {
            ivo.setAuthor(am.author());
            ivo.setDescribe(am.describe());
            ivo.setName(am.value());
            ivo.setVersion(am.version());
        }
        ApiParams apiParams = method.getAnnotation(ApiParams.class);
        KVEntity<List<ParameterVo>, List<HeadVo>> kv = this.extrad(method);
        if (null == kv) {
            return ivo;
        }
        List<ParameterVo> list = kv.getKey();
        if (null != list && list.size() > 0) {
            ApiParamIgnore hides = method.getAnnotation(ApiParamIgnore.class);
            if (null != hides && null != hides.value() && hides.value().length > 0) {
                if (hides.value().length == 1 && FieldUtil.isEmpty(hides.value()[0])) {
                    list = this.removeNotApiParam(list, apiParams);
                } else {
                    for (String string : hides.value()) {
                        FieldUtil.removeField(list, string);
                    }
                }
            }
            if (null != apiParams && apiParams.value().length > 0) {
                for (ApiParam apiParam : apiParams.value()) {
                    this.replaceReuestField(apiParam, list);
                }
            }
        }
        ivo.setParameters(list);
        List<HeadVo> headVos = kv.getValue();
        if (null != headVos && headVos.size() > 0) {
            if (null != apiParams && apiParams.value().length > 0) {
                for (ApiParam apiParam : apiParams.value()) {
                    for (HeadVo headVo : headVos) {
                        if (!headVo.getField().equals(apiParam.field())) continue;
                        if (!FieldUtil.isEmpty(apiParam.describe())) {
                            headVo.setDescribe(apiParam.describe());
                        }
                        headVo.setRequired(apiParam.required());
                        headVo.setMax(Integer.MAX_VALUE == apiParam.max() ? null : Integer.valueOf(apiParam.max()));
                        headVo.setMin(Integer.MIN_VALUE == apiParam.min() ? null : Integer.valueOf(apiParam.min()));
                        headVo.setRegexp(this.getRegexp(apiParam.regexp()));
                    }
                }
            }
            ivo.setHeads(headVos);
        }
        if (this.json) {
            ivo.setJson(true);
            ivo.setMethod("post");
        }
        return ivo;
    }

    private List<ParameterVo> removeNotApiParam(List<ParameterVo> list, ApiParams apiParams) {
        for (int i = 0; i < list.size(); ++i) {
            ParameterVo vo = list.get(i);
            boolean isOk = false;
            for (ApiParam param : apiParams.value()) {
                String[] keys = param.field().split("\\.");
                if (!keys[0].equals(vo.getField())) continue;
                if (keys.length > 1 && null != vo.getChildren() && vo.getChildren().size() > 0) {
                    list.get(i).setChildren(this.removeNotApiParam(vo.getChildren(), keys, 1));
                }
                isOk = true;
                break;
            }
            if (isOk) continue;
            list.remove(i);
            --i;
        }
        return list;
    }

    private List<ParameterVo> removeNotApiParam(List<ParameterVo> list, String[] keys, int index) {
        for (int i = 0; i < list.size(); ++i) {
            ParameterVo vo = list.get(i);
            boolean isOk = false;
            if (keys[index].equals(vo.getField())) {
                if (index < keys.length - 1 && null != vo.getChildren() && vo.getChildren().size() > 0) {
                    list.get(i).setChildren(this.removeNotApiParam(vo.getChildren(), keys, index++));
                }
                isOk = true;
                break;
            }
            if (isOk) continue;
            list.remove(i);
            --i;
        }
        return list;
    }

    private InterfaceVo extractUriAndType(Method method, String methodType) {
        InterfaceVo ivo = new InterfaceVo();
        ArrayList<String> types = new ArrayList<String>();
        ArrayList<String> uris = new ArrayList<String>();
        for (Annotation at : method.getAnnotations()) {
            DeleteMapping dm;
            if (at instanceof RequestMapping) {
                RequestMapping rm = (RequestMapping)at;
                if (null != rm.value() && rm.value().length > 0) {
                    for (String string : rm.value()) {
                        uris.add(string);
                    }
                }
                if (null == rm.method() || rm.method().length <= 0) continue;
                for (String string : rm.method()) {
                    types.add(string.toString().toUpperCase());
                }
                continue;
            }
            if (at instanceof DeleteMapping) {
                dm = (DeleteMapping)at;
                if (null != dm.path() && dm.path().length > 0) {
                    for (String string : dm.path()) {
                        uris.add(string);
                    }
                } else if (null != dm.value() && dm.value().length > 0) {
                    for (String string : dm.value()) {
                        uris.add(string);
                    }
                }
                types.add("DELETE");
                continue;
            }
            if (at instanceof GetMapping) {
                dm = (GetMapping)at;
                if (null != dm.path() && dm.path().length > 0) {
                    for (String string : dm.path()) {
                        uris.add(string);
                    }
                } else if (null != dm.value() && dm.value().length > 0) {
                    for (String string : dm.value()) {
                        uris.add(string);
                    }
                }
                types.add("GET");
                continue;
            }
            if (at instanceof PostMapping) {
                dm = (PostMapping)at;
                if (null != dm.path() && dm.path().length > 0) {
                    for (String string : dm.path()) {
                        uris.add(string);
                    }
                } else if (null != dm.value() && dm.value().length > 0) {
                    for (String string : dm.value()) {
                        uris.add(string);
                    }
                }
                types.add("POST");
                continue;
            }
            if (!(at instanceof PutMapping)) continue;
            dm = (PutMapping)at;
            if (null != dm.path() && dm.path().length > 0) {
                for (String string : dm.path()) {
                    uris.add(string);
                }
            } else if (null != dm.value() && dm.value().length > 0) {
                for (String string : dm.value()) {
                    uris.add(string);
                }
            }
            types.add("PUT");
        }
        if (uris.size() <= 0) {
            return null;
        }
        ivo.setUris(uris);
        if (types.size() > 0) {
            StringBuffer sb = new StringBuffer();
            for (String name : types) {
                sb.append(name + ",");
            }
            ivo.setMethod(sb.toString().substring(0, sb.toString().length() - 1));
        } else {
            ivo.setMethod(methodType);
        }
        return ivo;
    }

    private KVEntity<List<ParameterVo>, List<HeadVo>> extrad(Method method) {
        if (null != method.getParameterAnnotations() && method.getParameterAnnotations().length >= 1) {
            LocalVariableTableParameterNameDiscoverer u = new LocalVariableTableParameterNameDiscoverer();
            String[] names = u.getParameterNames(method);
            Class<?>[] clas = method.getParameterTypes();
            Type[] types = method.getGenericParameterTypes();
            ArrayList<ParameterVo> vos = new ArrayList<ParameterVo>();
            ArrayList<HeadVo> headVos = new ArrayList<HeadVo>();
            KVEntity<List<ParameterVo>, List<HeadVo>> kv = new KVEntity<List<ParameterVo>, List<HeadVo>>();
            kv.setKey(vos);
            kv.setValue(headVos);
            int index = -1;
            block0: for (int i = 0; i < method.getParameterAnnotations().length; ++i) {
                List<ParameterVo> list;
                Annotation[] ans = method.getParameterAnnotations()[i];
                RequestHeader head = null;
                boolean ignore = false;
                for (int j = 0; j < ans.length; ++j) {
                    if (ans[j] instanceof RequestBody) {
                        this.json = true;
                        index = i;
                    }
                    if (ans[j] instanceof ApiIgnore) {
                        ignore = true;
                        break;
                    }
                    if (!(ans[j] instanceof RequestHeader)) continue;
                    head = (RequestHeader)ans[j];
                }
                if (ignore) continue;
                Type genType = types[i];
                if (null != genType) {
                    FieldType type = FieldUtil.checkFieldType(genType);
                    genType = FieldUtil.extractGenType(genType, null, type);
                }
                if (null == (list = this.extractField(clas[i], names[i], genType))) continue;
                if (null != head) {
                    for (ParameterVo vo : list) {
                        HeadVo headVo = new HeadVo();
                        headVo.setDescribe(vo.getDescribe());
                        headVo.setField(vo.getField());
                        headVo.setRequired(vo.isRequired());
                        headVo.setType(vo.getType());
                        headVo.setRegexp(vo.getRegexp());
                        headVo.setMax(vo.getMax());
                        headVo.setMin(vo.getMin());
                        if (head.required()) {
                            headVo.setRequired(true);
                        }
                        headVos.add(headVo);
                        if (FieldUtil.isEmpty(head.value()) && FieldUtil.isEmpty(head.name())) continue;
                        if (!FieldUtil.isEmpty(head.value())) {
                            headVo.setField(head.value());
                            continue block0;
                        }
                        headVo.setField(head.name());
                        continue block0;
                    }
                    continue;
                }
                for (ParameterVo vo : list) {
                    if (this.json && i != index) {
                        vo.setUrl(true);
                    }
                    vos.add(vo);
                }
            }
            return kv;
        }
        return null;
    }

    private List<ParameterVo> extractField(Class<?> cla, String name, Type genType) {
        return this.extractField(cla, name, genType, true);
    }

    private List<ParameterVo> extractField(Class<?> cla, String name, Type genType, boolean isOne) {
        List<ParameterVo> vos = new ArrayList<ParameterVo>();
        ParameterVo vo = null;
        if (Date.class.isAssignableFrom(cla)) {
            vo = new ParameterVo();
            vo.setField(name);
            vo.setDescribe(name);
            vo.setType("date");
            vos.add(vo);
            return vos;
        }
        if (cla.isInterface()) {
            if (cla.isAssignableFrom(MultipartFile.class)) {
                vo = new ParameterVo();
                vo.setField(name);
                vo.setDescribe(name);
                vo.setType("File");
                vos.add(vo);
                return vos;
            }
            if (List.class.isAssignableFrom(cla) || Set.class.isAssignableFrom(cla)) {
                List<ParameterVo> vos2 = this.extractField((Class)genType, name, genType, false);
                if (isOne) {
                    return vos2;
                }
                if (null != vos2 && vos2.size() > 0) {
                    vo = new ParameterVo();
                    vo.setField(name);
                    vo.setDescribe(name);
                    vo.setType("Array<Object>");
                    vo.setChildren(vos2);
                    vos.add(vo);
                }
                return vos;
            }
        } else if (cla.isArray()) {
            if (Number.class.isAssignableFrom(cla = cla.getComponentType())) {
                vo = new ParameterVo();
                vo.setField(name);
                vo.setDescribe(name);
                vo.setType("Array<Number>");
                vos.add(vo);
                return vos;
            }
            if (cla == String.class) {
                vo = new ParameterVo();
                vo.setField(name);
                vo.setDescribe(name);
                vo.setType("Array<String>");
                vos.add(vo);
                return vos;
            }
        } else {
            if (Number.class.isAssignableFrom(cla)) {
                vo = new ParameterVo();
                vo.setField(name);
                vo.setDescribe(name);
                vo.setType("Number");
                vos.add(vo);
                return vos;
            }
            if (cla == String.class) {
                vo = new ParameterVo();
                vo.setField(name);
                vo.setDescribe(name);
                vo.setType("String");
                vos.add(vo);
                return vos;
            }
            vos = this.getRequestFields(cla, genType);
        }
        return null == vos ? null : (vos.size() > 0 ? vos : null);
    }

    public List<ParameterVo> getRequestFields(Class<?> cla, Type genType) {
        List<ParameterVo> list2;
        Field[] fis;
        if (null == cla) {
            return null;
        }
        ArrayList<ParameterVo> list = new ArrayList<ParameterVo>();
        for (Field field : fis = cla.getDeclaredFields()) {
            ApiIgnore ignore = field.getAnnotation(ApiIgnore.class);
            if (null != ignore || Modifier.isFinal(field.getModifiers()) || Modifier.isStatic(field.getModifiers())) continue;
            FieldType type = FieldUtil.checkFieldType(field.getGenericType());
            ParameterVo vo = null;
            Class<?> cla2 = null;
            switch (type) {
                case Clazz: {
                    vo = this.getRequestFieldInfo(field, field.getType(), false, null, type);
                    break;
                }
                case ArrayClass: {
                    cla2 = FieldUtil.extractClassByType(field.getGenericType(), null, type);
                    vo = this.getRequestFieldInfo(field, cla2, true, null, type);
                    break;
                }
                case ClassT: {
                    if (List.class.isAssignableFrom(field.getType()) || Set.class.isAssignableFrom(cla)) {
                        Class<?> gen = FieldUtil.extractClassByType(field.getGenericType(), genType, type);
                        if (null == gen) {
                            type = FieldUtil.checkFieldType(genType);
                            gen = FieldUtil.extractClassByType(genType, genType, type);
                        }
                        if (null == gen) break;
                        cla2 = gen;
                        vo = this.getRequestFieldInfo(field, cla2, true, null, type);
                        break;
                    }
                    cla2 = field.getType();
                    vo = this.getRequestFieldInfo(field, cla2, false, genType, type);
                    break;
                }
                case ArrayClassT: {
                    vo = this.getRequestFieldInfo(field, field.getType(), false, genType, type);
                    break;
                }
                case T: {
                    if (null == genType) break;
                    cla2 = FieldUtil.extractClassByType(field.getGenericType(), genType, type);
                    vo = this.getRequestFieldInfo(field, cla2, false, genType, type);
                    break;
                }
                case ArrayT: {
                    if (null == genType) break;
                    cla2 = FieldUtil.extractClassByType(field.getGenericType(), genType, type);
                    type = FieldType.T;
                    vo = this.getRequestFieldInfo(field, cla2, true, genType, type);
                }
            }
            if (null == vo) continue;
            list.add(vo);
        }
        if (Object.class != cla.getSuperclass() && !cla.getSuperclass().isInterface() && null != (list2 = this.getRequestFields(cla.getSuperclass(), genType))) {
            for (ParameterVo field : list2) {
                list.add(field);
            }
        }
        return list;
    }

    private ParameterVo getRequestFieldInfo(Field field, Class<?> cla2, boolean array, Type genType, FieldType type) {
        ApiField apiField = field.getAnnotation(ApiField.class);
        if (null != apiField && apiField.hide()) {
            return null;
        }
        ParameterVo vo = new ParameterVo();
        if (null != apiField) {
            vo.setDescribe(apiField.value());
        }
        vo.setField(field.getName());
        switch (FieldUtil.checkBaseClass(cla2)) {
            case -2: {
                return null;
            }
            case 1: {
                if (array) {
                    vo.setType("Array<Number>");
                    break;
                }
                vo.setType("Number");
                break;
            }
            case 2: {
                if (array) {
                    vo.setType("Array<String>");
                    break;
                }
                vo.setType("String");
                break;
            }
            case 3: {
                if (array) {
                    vo.setType("Array<Enum/Number>");
                    break;
                }
                vo.setType("Enum/Number");
                break;
            }
            case 0: {
                if (array) {
                    vo.setType("Array<Other>");
                } else {
                    vo.setType("Other");
                }
            }
            case 7: {
                if (array) {
                    vo.setType("Array<Date>");
                    break;
                }
                vo.setType("Date");
                break;
            }
            default: {
                if (array) {
                    vo.setType("Array<Object>");
                } else {
                    vo.setType("Object");
                }
                switch (type) {
                    case ClassT: 
                    case ArrayClassT: 
                    case T: 
                    case ArrayT: {
                        genType = FieldUtil.extractGenType(field.getGenericType(), genType, type);
                        break;
                    }
                    case Clazz: 
                    case ArrayClass: {
                        genType = null;
                    }
                }
                List<ParameterVo> children = null;
                switch (type) {
                    case Clazz: {
                        children = this.getRequestFields(cla2, genType);
                        break;
                    }
                    case ArrayClass: {
                        cla2 = FieldUtil.extractClassByType(field.getGenericType(), genType, type);
                        if (null == cla2) break;
                        children = this.getRequestFields(cla2, genType);
                        break;
                    }
                    case T: 
                    case ArrayT: {
                        if (null == cla2) break;
                        children = this.getRequestFields(cla2, genType);
                        break;
                    }
                    default: {
                        children = this.getRequestFields(cla2, genType);
                    }
                }
                if (null == children) break;
                vo.setChildren(children);
            }
        }
        return vo;
    }

    private void replaceReuestField(ApiParam param, List<ParameterVo> list) {
        String[] keys = param.field().split("\\.");
        ParamBaseVo tempVo = null;
        List<ParameterVo> tempChildren = list;
        block0: for (String key : keys) {
            for (ParameterVo vo : tempChildren) {
                if (!vo.getField().equals(key)) continue;
                tempVo = vo;
                tempChildren = vo.getChildren();
                continue block0;
            }
        }
        if (tempVo != null) {
            if (!FieldUtil.isEmpty(param.describe())) {
                tempVo.setDescribe(param.describe());
            }
            tempVo.setRequired(param.required());
            ((ParameterVo)tempVo).setRegexp(this.getRegexp(param.regexp()));
            ((ParameterVo)tempVo).setMax(Integer.MAX_VALUE == param.max() ? null : Integer.valueOf(param.max()));
            ((ParameterVo)tempVo).setMin(Integer.MIN_VALUE == param.min() ? null : Integer.valueOf(param.min()));
        }
    }

    private String getRegexp(String regexp) {
        if (regexp.startsWith("${") && regexp.endsWith("}")) {
            String key = regexp.substring(2, regexp.length() - 1);
            String reg = this.config.getRegexps().get(key);
            if (FieldUtil.isEmpty(reg)) {
                return null;
            }
            return reg;
        }
        return regexp;
    }
}

