/*
 * Decompiled with CFR 0.152.
 */
package com.github.ddm4j.api.document.utils;

import com.github.ddm4j.api.document.annotation.ApiController;
import com.github.ddm4j.api.document.annotation.ApiHeaderCancel;
import com.github.ddm4j.api.document.annotation.ApiIgnore;
import com.github.ddm4j.api.document.bean.ControllerVo;
import com.github.ddm4j.api.document.bean.HeadVo;
import com.github.ddm4j.api.document.bean.InterfaceVo;
import com.github.ddm4j.api.document.config.CheckConfig;
import com.github.ddm4j.api.document.config.DocumentConfig;
import com.github.ddm4j.api.document.config.bean.RequestHeaderBean;
import com.github.ddm4j.api.document.utils.ClassUtil;
import com.github.ddm4j.api.document.utils.FieldUtil;
import com.github.ddm4j.api.document.utils.MethodRequestUtil;
import com.github.ddm4j.api.document.utils.MethodResponseUtil;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScanControllerUtil {
    CheckConfig config;
    DocumentConfig documentConfig;
    Logger logger = LoggerFactory.getLogger(ScanControllerUtil.class);

    public ScanControllerUtil(CheckConfig config, DocumentConfig documentConfig) {
        this.config = config;
        this.documentConfig = documentConfig;
    }

    public List<ControllerVo> scan(String packagePath, String base_path) {
        Set<Class<?>> classList = ClassUtil.getClasses(packagePath);
        if (null == classList || classList.size() == 0) {
            this.logger.error("\u6ca1\u6709\u627e\u5230 Controller \u8def\u5f84\uff1a" + packagePath);
            return null;
        }
        ArrayList<ControllerVo> controllers = new ArrayList<ControllerVo>();
        MethodRequestUtil requestUtil = new MethodRequestUtil(this.config);
        MethodResponseUtil responseUtil = new MethodResponseUtil();
        List<HeadVo> headVosConfig = this.extractHeaderInfo();
        for (Class<?> cla : classList) {
            if (null != cla.getAnnotation(ApiIgnore.class) || null == cla.getAnnotation(RestController.class) && null == cla.getAnnotation(Controller.class)) continue;
            ControllerVo cvo = this.extractControllerInfo(cla, base_path);
            List<HeadVo> headVos = this.handleHeaderCancel(headVosConfig, cla.getAnnotation(ApiHeaderCancel.class));
            ArrayList<InterfaceVo> interfaces = null;
            Method[] methods = cla.getMethods();
            if (null != methods && methods.length > 0) {
                interfaces = new ArrayList<InterfaceVo>();
                for (Method method : methods) {
                    InterfaceVo ivo;
                    if (null != method.getAnnotation(ApiIgnore.class) || null == (ivo = requestUtil.getRequestVo(method, cvo.getMethod()))) continue;
                    List<HeadVo> methodVos = this.handleHeaderCancel(headVos, method.getAnnotation(ApiHeaderCancel.class));
                    if (null != methodVos) {
                        this.handleMethodHander(ivo, methodVos);
                    }
                    ivo.setResponses(responseUtil.getResponseVo(method));
                    if (null != cvo.getUris() && cvo.getUris().size() > 0) {
                        if (null == ivo.getUris() || ivo.getUris().size() <= 0) continue;
                        for (String path1 : cvo.getUris()) {
                            for (String path2 : ivo.getUris()) {
                                InterfaceVo vo2 = new InterfaceVo();
                                BeanUtils.copyProperties((Object)ivo, (Object)vo2);
                                if (!path1.startsWith("/")) {
                                    path1 = "/" + path1;
                                }
                                if (path1.endsWith("/")) {
                                    path1 = path1.substring(0, path1.length() - 1);
                                }
                                if (!path2.startsWith("/")) {
                                    path2 = "/" + path2;
                                }
                                vo2.setUri(path1 + path2);
                                vo2.setUris(null);
                                interfaces.add(vo2);
                            }
                        }
                        continue;
                    }
                    if (null != ivo.getUris() && ivo.getUris().size() > 0) {
                        for (String path : ivo.getUris()) {
                            InterfaceVo vo2 = new InterfaceVo();
                            BeanUtils.copyProperties((Object)ivo, (Object)vo2);
                            if (!path.startsWith("/")) {
                                path = "/" + path;
                            }
                            vo2.setUri(path);
                            vo2.setUris(null);
                            interfaces.add(vo2);
                        }
                        continue;
                    }
                    interfaces.add(ivo);
                }
            }
            cvo.setInterfaces(interfaces);
            controllers.add(cvo);
        }
        return controllers;
    }

    private void handleMethodHander(InterfaceVo ivo, List<HeadVo> methodVos) {
        if (null != methodVos && methodVos.size() > 0) {
            for (HeadVo head : methodVos) {
                if (null == ivo.getHeads()) {
                    ivo.setHeads(new ArrayList<HeadVo>());
                }
                boolean isOk = true;
                for (HeadVo vo : ivo.getHeads()) {
                    if (!vo.getField().equals(head.getField())) continue;
                    isOk = false;
                    break;
                }
                if (!isOk) continue;
                ivo.getHeads().add(head);
            }
        }
    }

    private List<HeadVo> handleHeaderCancel(List<HeadVo> headVosConfig, ApiHeaderCancel headerCancel) {
        if (null == headerCancel) {
            return headVosConfig;
        }
        ArrayList<HeadVo> headVos = new ArrayList<HeadVo>();
        if (headerCancel.value().length == 1 && !FieldUtil.isEmpty(headerCancel.value()[0])) {
            for (HeadVo headVo : headVosConfig) {
                boolean isOk = true;
                for (String key : headerCancel.value()) {
                    if (!key.equals(headVo.getField())) continue;
                    isOk = false;
                    break;
                }
                if (!isOk) continue;
                headVos.add(headVo);
            }
        }
        return headVos;
    }

    private List<HeadVo> extractHeaderInfo() {
        ArrayList<HeadVo> headVos = new ArrayList<HeadVo>();
        for (Map.Entry<String, RequestHeaderBean> bean : this.documentConfig.getHeader().entrySet()) {
            HeadVo vo = new HeadVo();
            vo.setField(bean.getKey());
            if (null != bean.getValue()) {
                vo.setDescribe(bean.getValue().getDescribe());
                vo.setMax(bean.getValue().getMax());
                vo.setMin(bean.getValue().getMin());
                vo.setRegexp(bean.getValue().getRegexp());
                vo.setRequired(bean.getValue().getRequired());
                vo.setType(bean.getValue().getType());
            }
            headVos.add(vo);
        }
        return headVos;
    }

    private ControllerVo extractControllerInfo(Class<?> cla, String base_path) {
        ApiController apiController;
        ControllerVo cvo = new ControllerVo();
        cvo.setController(cla.getName().substring(cla.getName().lastIndexOf(".") + 1));
        ResponseBody json = cla.getAnnotation(ResponseBody.class);
        if (null == json) {
            json = cla.getAnnotation(RestController.class);
        }
        if (null != json) {
            cvo.setJson(true);
        }
        if (null != (apiController = cla.getAnnotation(ApiController.class))) {
            cvo.setName(apiController.value());
            cvo.setDescribe(apiController.describe());
            cvo.setVersion(apiController.version());
            cvo.setAuthor(apiController.author());
        } else {
            cvo.setName(cvo.getController());
            cvo.setVersion("V1.0");
        }
        RequestMapping rquestMapping = cla.getAnnotation(RequestMapping.class);
        if (null != rquestMapping) {
            if (null != base_path && !"".equals(base_path.trim()) && !(base_path = base_path.trim()).startsWith("/")) {
                base_path = "/" + base_path;
            }
            ArrayList<String> uris = new ArrayList<String>();
            if (null != rquestMapping.value() && rquestMapping.value().length > 0) {
                for (String path : rquestMapping.value()) {
                    if (!path.startsWith("/")) {
                        path = "/" + path;
                    }
                    uris.add(base_path + path);
                }
            }
            if (uris.size() > 0) {
                cvo.setUris(uris);
            }
            if (null != rquestMapping.method() && rquestMapping.method().length > 0) {
                cvo.setMethod(rquestMapping.method()[0].toString().toUpperCase());
            }
        }
        return cvo;
    }
}

