/*
 * Decompiled with CFR 0.152.
 */
package develop.framework.application.jpa;

import com.github.developframework.kite.spring.mvc.response.EmptyKiteResponse;
import com.github.developframework.kite.spring.mvc.response.KiteResponse;
import develop.framework.application.jpa.BaseRepository;
import develop.framework.application.jpa.ResourceName;
import develop.framework.commons.exceptions.BusinessException;
import develop.framework.commons.utils.Assert;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@RequestMapping(value={"{resourceName}"})
public class ResourceSearchController {
    private static final String RESOURCE_KEY = "resource";
    @Autowired
    private List<BaseRepository> baseRepositories;

    @GetMapping(value={"{id}"})
    public KiteResponse resourceDetailById(@PathVariable String resourceName, @PathVariable Long id) {
        for (BaseRepository baseRepository : this.baseRepositories) {
            if (!baseRepository.support(resourceName)) continue;
            Class domainClass = baseRepository.getDomainClass();
            ResourceName annotation = (ResourceName)AnnotationUtils.findAnnotation(domainClass, ResourceName.class);
            Optional resourceOptional = baseRepository.findById(id);
            EmptyKiteResponse kiteResponse = new EmptyKiteResponse(annotation.kiteNamespace(), annotation.detailKiteTemplateId());
            kiteResponse.getDataModel().putData(RESOURCE_KEY, Assert.resourceExist((String)resourceName, (Optional)resourceOptional));
            return kiteResponse;
        }
        throw new BusinessException("There is no such resource \"%s\".", new Object[]{resourceName});
    }
}

