/*
 * Decompiled with CFR 0.152.
 */
package develop.toolkit.world.normal;

import develop.toolkit.base.struct.TwoValues;
import java.time.LocalDate;
import java.time.MonthDay;
import java.time.temporal.ChronoUnit;

public enum Season {
    SPRING(1),
    SUMMER(2),
    AUTUMN(3),
    WINTER(4);

    private int value;

    private Season(int value) {
        this.value = value;
    }

    public TwoValues<MonthDay, MonthDay> range() {
        switch (this) {
            case SPRING: {
                return new TwoValues((Object)MonthDay.of(1, 1), (Object)MonthDay.of(3, 31));
            }
            case SUMMER: {
                return new TwoValues((Object)MonthDay.of(4, 1), (Object)MonthDay.of(6, 30));
            }
            case AUTUMN: {
                return new TwoValues((Object)MonthDay.of(7, 1), (Object)MonthDay.of(9, 30));
            }
            case WINTER: {
                return new TwoValues((Object)MonthDay.of(10, 1), (Object)MonthDay.of(12, 31));
            }
        }
        throw new AssertionError();
    }

    public int getDayOfSeason(LocalDate day) {
        if (Season.isDayAt(MonthDay.from(day), this)) {
            return (int)((MonthDay)this.range().getFirstValue()).atYear(day.getYear()).until(day, ChronoUnit.DAYS);
        }
        return -1;
    }

    public static Season dayAt(MonthDay monthDay) {
        for (Season season : Season.values()) {
            TwoValues<MonthDay, MonthDay> range = season.range();
            if (monthDay.compareTo((MonthDay)range.getFirstValue()) < 0 || monthDay.compareTo((MonthDay)range.getSecondValue()) > 0) continue;
            return season;
        }
        throw new AssertionError();
    }

    public static boolean isDayAt(MonthDay monthDay, Season season) {
        return Season.dayAt(monthDay) == season;
    }

    public static Season valueOf(int value) {
        for (Season season : Season.values()) {
            if (season.getValue() != value) continue;
            return season;
        }
        return null;
    }

    public int getValue() {
        return this.value;
    }
}

