/*
 * Decompiled with CFR 0.152.
 */
package develop.toolkit.world.person;

import develop.toolkit.world.normal.Region;
import develop.toolkit.world.person.Sex;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;

public class IdentificationCard
implements Serializable {
    private static final long serialVersionUID = -3165541953812379182L;
    private String card;
    private Region region;
    private Sex sex;
    private LocalDate birthday;

    public IdentificationCard(String card) {
        if (!IdentificationCard.isValid(card)) {
            throw new IllegalArgumentException("invalid identification card");
        }
        this.card = card;
    }

    public IdentificationCard(String card, RegionParser regionParser) {
        this(card);
        this.parse(regionParser);
    }

    public String toString() {
        return this.card;
    }

    public boolean length15() {
        return this.card.length() == 15;
    }

    public boolean length18() {
        return this.card.length() == 18;
    }

    public static boolean isValid(String card) {
        if (card != null && card.matches("^\\d{15}|(\\d{17}[\\dXx])$")) {
            if (card.length() == 15) {
                return true;
            }
            return card.charAt(17) == IdentificationCard.computeLastCode(card.substring(0, card.length() - 1));
        }
        return false;
    }

    public void parse(RegionParser regionParser) {
        if (regionParser != null) {
            this.region = regionParser.parseRegion(Integer.parseInt(this.card.substring(0, 6)));
        }
        switch (this.card.length()) {
            case 15: {
                this.birthday = LocalDate.parse("19" + this.card.substring(6, 12), DateTimeFormatter.ofPattern("yyyyMMdd"));
                this.sex = this.card.charAt(14) % 2 == 0 ? Sex.FEMALE : Sex.MALE;
                break;
            }
            case 18: {
                this.birthday = LocalDate.parse(this.card.substring(6, 14), DateTimeFormatter.ofPattern("yyyyMMdd"));
                this.sex = this.card.charAt(16) % 2 == 0 ? Sex.FEMALE : Sex.MALE;
            }
        }
    }

    public int getAge() {
        LocalDate now = LocalDate.now();
        int month = now.getMonth().getValue();
        int day = now.getDayOfMonth();
        boolean flag = this.birthday.getMonth().getValue() > month ? true : (this.birthday.getMonth().getValue() < month ? false : this.birthday.getDayOfMonth() > day);
        return now.getYear() - this.birthday.getYear() - (flag ? 1 : 0);
    }

    public static char computeLastCode(String front17Chars) {
        int[] VERIFY_NUMBERS = new int[]{7, 9, 10, 5, 8, 4, 2, 1, 6, 3, 7, 9, 10, 5, 8, 4, 2, 1};
        char[] TARGET_CHARS = new char[]{'1', '0', 'X', '9', '8', '7', '6', '5', '4', '3', '2'};
        int sum = 0;
        for (int i = 0; i < front17Chars.length(); ++i) {
            sum += (front17Chars.charAt(i) - 48) * VERIFY_NUMBERS[i];
        }
        return TARGET_CHARS[sum % 11];
    }

    public String getCard() {
        return this.card;
    }

    public Region getRegion() {
        return this.region;
    }

    public Sex getSex() {
        return this.sex;
    }

    public LocalDate getBirthday() {
        return this.birthday;
    }

    public void setCard(String card) {
        this.card = card;
    }

    public void setRegion(Region region) {
        this.region = region;
    }

    public void setSex(Sex sex) {
        this.sex = sex;
    }

    public void setBirthday(LocalDate birthday) {
        this.birthday = birthday;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IdentificationCard)) {
            return false;
        }
        IdentificationCard other = (IdentificationCard)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$card = this.getCard();
        String other$card = other.getCard();
        return !(this$card == null ? other$card != null : !this$card.equals(other$card));
    }

    protected boolean canEqual(Object other) {
        return other instanceof IdentificationCard;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $card = this.getCard();
        result = result * 59 + ($card == null ? 43 : $card.hashCode());
        return result;
    }

    public IdentificationCard() {
    }

    public static interface RegionParser {
        public Region parseRegion(int var1);
    }
}

