/*
 * Decompiled with CFR 0.152.
 */
package develop.toolkit.world.verify;

public final class CarPlateVerify {
    public static boolean checkValid(String plate) {
        String PROVINCES = "\u4eac\u6d25\u664b\u5180\u8499\u8fbd\u5409\u9ed1\u6caa\u82cf\u6d59\u7696\u95fd\u8d63\u9c81\u8c6b\u9102\u6e58\u7ca4\u6842\u743c\u6e1d\u5ddd\u8d35\u4e91\u85cf\u9655\u7518\u9752\u5b81\u65b0";
        String provinceShortName = String.valueOf(plate.charAt(0));
        if (!"\u4eac\u6d25\u664b\u5180\u8499\u8fbd\u5409\u9ed1\u6caa\u82cf\u6d59\u7696\u95fd\u8d63\u9c81\u8c6b\u9102\u6e58\u7ca4\u6842\u743c\u6e1d\u5ddd\u8d35\u4e91\u85cf\u9655\u7518\u9752\u5b81\u65b0".contains(provinceShortName)) {
            return false;
        }
        if (plate.length() == 7) {
            return CarPlateVerify.validNormal(plate);
        }
        if (plate.length() == 8) {
            return CarPlateVerify.validNewEnergy(plate);
        }
        return false;
    }

    public static boolean checkValidRelaxed(String plate) {
        return plate.matches("^[\u4eac\u6d25\u664b\u5180\u8499\u8fbd\u5409\u9ed1\u6caa\u82cf\u6d59\u7696\u95fd\u8d63\u9c81\u8c6b\u9102\u6e58\u7ca4\u6842\u743c\u6e1d\u5ddd\u8d35\u4e91\u85cf\u9655\u7518\u9752\u5b81\u65b0][A-Z].{5,6}$");
    }

    private static boolean validNormal(String plate) {
        String PLATE_CHARS_ORG = "ABCDEFGHJKLMNPQRSTUVWXYZ";
        String PLATE_CHARS = "ABCDEFGHJKLMNPQRSTUVWXYZ0123456789";
        if ("ABCDEFGHJKLMNPQRSTUVWXYZ".contains(String.valueOf(plate.charAt(1)))) {
            for (int i = 2; i < 7; ++i) {
                String ch = String.valueOf(plate.charAt(i));
                if ("ABCDEFGHJKLMNPQRSTUVWXYZ0123456789".contains(ch)) continue;
                return i == 6 && "\u5b66\u6302".contains(ch);
            }
            return true;
        }
        return false;
    }

    private static boolean validNewEnergy(String plate) {
        String PLATE_CHARS_ORG = "ABCDEFGHJKLMNPQRSTUVWXYZ";
        if ("ABCDEFGHJKLMNPQRSTUVWXYZ".contains(String.valueOf(plate.charAt(1))) && "123456789DF".contains(String.valueOf(plate.charAt(2))) && "ABCDEFGHJKLMNPQRSTUVWXYZ123456789".contains(String.valueOf(plate.charAt(3))) && "0123456789DF".contains(String.valueOf(plate.charAt(7)))) {
            for (int i = 4; i < 6; ++i) {
                if (!"0123456789".contains(String.valueOf(plate.charAt(i)))) continue;
                return true;
            }
        }
        return false;
    }
}

