/*
 * Decompiled with CFR 0.152.
 */
package com.github.developframework.jsonview.core.processor;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.developframework.jsonview.core.element.PropertyElement;
import com.github.developframework.jsonview.core.processor.Context;
import com.github.developframework.jsonview.core.processor.PropertyProcessor;
import com.github.developframework.jsonview.data.Expression;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class DatePropertyProcessor
extends PropertyProcessor {
    private DateFormat dateFormat;
    private static final List<Class<?>> ACCEPT_CLASS_LIST = new ArrayList(9);

    public DatePropertyProcessor(Context context, PropertyElement element, Expression parentExpression) {
        this(context, element, parentExpression, null);
    }

    public DatePropertyProcessor(Context context, PropertyElement element, Expression parentExpression, String pattern) {
        super(context, element, parentExpression);
        this.dateFormat = new SimpleDateFormat(StringUtils.isBlank((CharSequence)pattern) ? "yyyy-MM-dd HH:mm:ss" : pattern);
        ACCEPT_CLASS_LIST.add(java.util.Date.class);
        ACCEPT_CLASS_LIST.add(Calendar.class);
        ACCEPT_CLASS_LIST.add(Date.class);
        ACCEPT_CLASS_LIST.add(Time.class);
        ACCEPT_CLASS_LIST.add(Timestamp.class);
        ACCEPT_CLASS_LIST.add(LocalDate.class);
        ACCEPT_CLASS_LIST.add(LocalDateTime.class);
        ACCEPT_CLASS_LIST.add(LocalTime.class);
        ACCEPT_CLASS_LIST.add(Instant.class);
    }

    @Override
    protected boolean support(Class<?> sourceClass) {
        return ACCEPT_CLASS_LIST.contains(sourceClass);
    }

    @Override
    protected void handle(ObjectNode parentNode, Class<?> clazz, Object value, String showName) {
        java.util.Date date = this.transformDate(clazz, value);
        if (Objects.isNull(date)) {
            parentNode.putNull(showName);
            return;
        }
        parentNode.put(showName, this.dateFormat.format(date));
    }

    protected java.util.Date transformDate(Class<?> clazz, Object value) {
        java.util.Date date = null;
        if (clazz == java.util.Date.class) {
            date = (java.util.Date)value;
        } else if (clazz == Date.class) {
            date = ((Calendar)value).getTime();
        } else if (clazz == Date.class) {
            date = new java.util.Date(((Date)value).getTime());
        } else if (clazz == Time.class) {
            date = new java.util.Date(((Time)value).getTime());
        } else if (clazz == Timestamp.class) {
            date = new java.util.Date(((Timestamp)value).getTime());
        } else if (clazz == LocalDateTime.class) {
            date = java.util.Date.from(((LocalDateTime)value).atZone(ZoneId.systemDefault()).toInstant());
        } else if (clazz == LocalDate.class) {
            LocalTime localTime = LocalTime.parse("00:00:00");
            LocalDateTime localDateTime = LocalDateTime.of((LocalDate)value, localTime);
            date = java.util.Date.from(localDateTime.atZone(ZoneId.systemDefault()).toInstant());
        } else if (clazz == LocalTime.class) {
            LocalDate localDate = LocalDate.now();
            LocalDateTime localDateTime = LocalDateTime.of(localDate, (LocalTime)value);
            date = java.util.Date.from(localDateTime.atZone(ZoneId.systemDefault()).toInstant());
        } else if (clazz == Instant.class) {
            date = java.util.Date.from((Instant)value);
        }
        return date;
    }
}

