/*
 * Decompiled with CFR 0.152.
 */
package com.github.developframework.jsonview.core.element;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.developframework.jsonview.core.element.ContainerElement;
import com.github.developframework.jsonview.core.element.Element;
import com.github.developframework.jsonview.core.element.JsonviewConfiguration;
import com.github.developframework.jsonview.core.element.ObjectElement;
import com.github.developframework.jsonview.core.processor.ArrayProcessor;
import com.github.developframework.jsonview.core.processor.Context;
import com.github.developframework.jsonview.core.processor.Processor;
import com.github.developframework.jsonview.data.Expression;
import java.util.Optional;

public class ArrayElement
extends ContainerElement {
    private ObjectElement childObjectElement;
    private String mapFunctionValue;

    public ArrayElement(JsonviewConfiguration configuration, String data, String alias) {
        super(configuration, data, alias);
        this.childObjectElement = new ObjectElement(configuration, data, alias);
    }

    @Override
    public Optional<Processor<? extends Element, ? extends JsonNode>> createProcessor(Context context, ObjectNode parentNode, Expression parentExpression) {
        ArrayProcessor processor = new ArrayProcessor(context, this, parentExpression);
        Optional<Object> optional = context.getDataModel().getData(processor.getExpression());
        if (optional.isPresent()) {
            ArrayNode arrayNode = parentNode.putArray(this.showName());
            processor.setNode(arrayNode);
            return Optional.of(processor);
        }
        if (!this.nullHidden) {
            parentNode.putNull(this.showName());
        }
        return Optional.empty();
    }

    @Override
    public void addChildElement(Element element) {
        super.addChildElement(element);
        this.childObjectElement.addChildElement(element);
    }

    public Optional<String> getMapFunctionValueOptional() {
        return Optional.ofNullable(this.mapFunctionValue);
    }

    public ObjectElement getChildObjectElement() {
        return this.childObjectElement;
    }

    public void setMapFunctionValue(String mapFunctionValue) {
        this.mapFunctionValue = mapFunctionValue;
    }
}

