/*
 * Decompiled with CFR 0.152.
 */
package com.github.developframework.jsonview.core.element;

import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.github.developframework.jsonview.core.element.Element;
import com.github.developframework.jsonview.core.element.JsonviewConfiguration;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public abstract class DescribeContentElement
extends Element {
    protected String data;
    protected String alias;
    protected boolean nullHidden;

    public DescribeContentElement(JsonviewConfiguration configuration, String data, String alias) {
        super(configuration);
        this.data = data;
        this.alias = alias;
    }

    public String showName() {
        if (StringUtils.isNotBlank((CharSequence)this.alias)) {
            return this.alias;
        }
        String data = this.ignoreHeadSign(this.data);
        int dotLastIndex = data.lastIndexOf(".");
        data = dotLastIndex == -1 ? data : data.substring(dotLastIndex + 1);
        PropertyNamingStrategy strategy = this.configuration.getPropertyNamingStrategy();
        if (strategy == null) {
            return data;
        }
        return strategy.nameForField(null, null, data);
    }

    private final String ignoreHeadSign(String data) {
        Objects.requireNonNull(data);
        if (data.startsWith("#")) {
            return data.substring(1);
        }
        return data;
    }

    @Deprecated
    private final String camelCaseToUnderline(String camelCaseStr) {
        StringBuffer sb = new StringBuffer();
        int size = camelCaseStr.length();
        for (int i = 0; i < size; ++i) {
            char ch = camelCaseStr.charAt(i);
            if (ch >= 'A' && ch <= 'Z') {
                if (i == 0) {
                    sb.append((char)(ch + 32));
                    continue;
                }
                sb.append('_').append((char)(ch + 32));
                continue;
            }
            sb.append(ch);
        }
        return sb.toString();
    }

    public boolean isNullHidden() {
        return this.nullHidden;
    }

    public void setNullHidden(String nullHiddenStr) {
        this.nullHidden = StringUtils.isBlank((CharSequence)nullHiddenStr) ? false : new Boolean(nullHiddenStr);
    }

    public boolean equals(Object obj) {
        if (obj instanceof Element) {
            return this.data.equals(((DescribeContentElement)obj).getData()) || this == obj;
        }
        return false;
    }

    public String getData() {
        return this.data;
    }

    public void setData(String data) {
        this.data = data;
    }

    public String getAlias() {
        return this.alias;
    }
}

