/*
 * Decompiled with CFR 0.152.
 */
package com.github.developframework.jsonview.core.element;

import com.github.developframework.jsonview.core.element.Jsonview;
import com.github.developframework.jsonview.exception.JsonviewNotFoundException;
import com.github.developframework.jsonview.exception.ResourceNotUniqueException;
import java.util.HashMap;
import java.util.Objects;

public class JsonviewPackage
extends HashMap<String, Jsonview> {
    private static final long serialVersionUID = -7671014418821915082L;
    private String namespace;

    public JsonviewPackage(String namespace) {
        this.namespace = namespace;
    }

    public Jsonview getJsonviewById(String id) {
        Jsonview jsonview = (Jsonview)this.get(id);
        if (Objects.isNull(jsonview)) {
            throw new JsonviewNotFoundException(id, this.namespace);
        }
        return jsonview;
    }

    public void push(Jsonview jsonview) {
        String id = jsonview.getId();
        if (super.containsKey(id)) {
            throw new ResourceNotUniqueException(String.format("Jsonview id \"%s\" is exist.", id));
        }
        super.put(jsonview.getId(), jsonview);
    }

    public String getNamespace() {
        return this.namespace;
    }
}

