/*
 * Decompiled with CFR 0.152.
 */
package com.github.developframework.jsonview.core.element;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.developframework.jsonview.core.element.ArrayElement;
import com.github.developframework.jsonview.core.element.Element;
import com.github.developframework.jsonview.core.element.JsonviewConfiguration;
import com.github.developframework.jsonview.core.element.ObjectElement;
import com.github.developframework.jsonview.core.processor.Context;
import com.github.developframework.jsonview.core.processor.MappingObjectProcessor;
import com.github.developframework.jsonview.core.processor.Processor;
import com.github.developframework.jsonview.data.Expression;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public class MappingObjectElement
extends ObjectElement {
    private String source;
    private String target;
    private ObjectElement childObjectElement;
    private ArrayElement childArrayElement;
    private MappingType mappingType;

    public MappingObjectElement(JsonviewConfiguration configuration, String data, String alias) {
        super(configuration, data, alias);
        this.childObjectElement = new ObjectElement(configuration, data, alias);
        this.childArrayElement = new ArrayElement(configuration, data, alias);
    }

    @Override
    public void addChildElement(Element element) {
        super.addChildElement(element);
        this.childObjectElement.addChildElement(element);
        this.childArrayElement.addChildElement(element);
    }

    @Override
    public Optional<Processor<? extends Element, ? extends JsonNode>> createProcessor(Context context, ObjectNode parentNode, Expression parentExpression) {
        MappingObjectProcessor processor = new MappingObjectProcessor(context, this, parentExpression);
        Optional<Object> optional = context.getDataModel().getData(processor.getExpression());
        if (optional.isPresent()) {
            return Optional.of(processor);
        }
        if (!this.nullHidden) {
            parentNode.putNull(this.showName());
        }
        return Optional.empty();
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public ObjectElement getChildObjectElement() {
        return this.childObjectElement;
    }

    public ArrayElement getChildArrayElement() {
        return this.childArrayElement;
    }

    public MappingType getMappingType() {
        return this.mappingType;
    }

    public void setMappingType(MappingType mappingType) {
        this.mappingType = mappingType;
    }

    public static enum MappingType {
        AUTO,
        SINGLE,
        MULTIPLE;


        public static MappingType parse(String typeStr) {
            if (StringUtils.isBlank((CharSequence)typeStr)) {
                return AUTO;
            }
            return MappingType.valueOf(typeStr.toUpperCase());
        }
    }
}

