/*
 * Decompiled with CFR 0.152.
 */
package com.github.developframework.jsonview.core.processor;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.developframework.jsonview.core.element.ArrayElement;
import com.github.developframework.jsonview.core.element.Element;
import com.github.developframework.jsonview.core.processor.ContainerProcessor;
import com.github.developframework.jsonview.core.processor.Context;
import com.github.developframework.jsonview.core.processor.DescribeContentProcessor;
import com.github.developframework.jsonview.core.processor.ObjectInArrayProcessor;
import com.github.developframework.jsonview.core.processor.Processor;
import com.github.developframework.jsonview.data.DataModel;
import com.github.developframework.jsonview.data.Expression;
import com.github.developframework.jsonview.exception.JsonviewException;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArrayProcessor
extends ContainerProcessor<ArrayElement, ArrayNode> {
    private static final Logger log = LoggerFactory.getLogger(ArrayProcessor.class);
    private Optional<Function> mapFunction;

    public ArrayProcessor(Context context, ArrayElement element, Expression parentExpression) {
        super(context, element, parentExpression);
        this.mapFunction = this.mapFunction(element.getMapFunctionValueOptional(), context.getDataModel());
        if (this.mapFunction != null && !element.isChildEmpty()) {
            log.warn("The child element invalid, because you use \"map-function\" attribute.");
        }
    }

    @Override
    protected void process(DescribeContentProcessor<? extends Element, ? extends JsonNode> parentProcessor) {
        DataModel dataModel = parentProcessor.getContext().getDataModel();
        Optional<Object> objOptional = dataModel.getData(this.expression);
        if (objOptional.isPresent()) {
            Object obj = objOptional.get();
            int size = 0;
            if (obj.getClass().isArray()) {
                size = ((Object[])obj).length;
            } else if (obj instanceof Collection) {
                size = ((Collection)obj).size();
            }
            for (int i = 0; i < size; ++i) {
                this.single(Expression.buildArrayExpression(this.expression, i), size);
            }
        }
    }

    protected void process(Processor<? extends Element, ? extends JsonNode> parentProcessor, List<Expression> expressionList) {
        int size = expressionList.size();
        for (Expression expression : expressionList) {
            this.single(expression, size);
        }
    }

    private void single(Expression expression, int size) {
        if (((ArrayElement)this.element).isChildEmpty() || this.mapFunction.isPresent()) {
            this.empty(expression.getIndex());
        } else {
            ObjectInArrayProcessor childProcessor = new ObjectInArrayProcessor(this.context, ((ArrayElement)this.element).getChildObjectElement(), expression, size);
            ObjectNode objectNode = this.context.getObjectMapper().createObjectNode();
            childProcessor.setNode(objectNode);
            childProcessor.process(null);
            ((ArrayNode)this.node).add((JsonNode)objectNode);
        }
    }

    private void empty(int index) {
        Optional<Object> objectOptional = this.context.getDataModel().getData(Expression.buildArrayExpression(this.expression, index));
        if (!objectOptional.isPresent()) {
            ((ArrayNode)this.node).addNull();
            return;
        }
        Object object = objectOptional.get();
        if (this.mapFunction.isPresent()) {
            object = this.mapFunction.get().apply(object);
        }
        if (object instanceof String) {
            ((ArrayNode)this.node).add((String)object);
        } else if (object instanceof Integer) {
            ((ArrayNode)this.node).add((Integer)object);
        } else if (object instanceof Long) {
            ((ArrayNode)this.node).add((Long)object);
        } else if (object instanceof Short) {
            ((ArrayNode)this.node).add((int)((Short)object).shortValue());
        } else if (object instanceof Boolean) {
            ((ArrayNode)this.node).add((Boolean)object);
        } else if (object instanceof Float) {
            ((ArrayNode)this.node).add((Float)object);
        } else if (object instanceof Double) {
            ((ArrayNode)this.node).add((Double)object);
        } else if (object instanceof BigDecimal) {
            ((ArrayNode)this.node).add((BigDecimal)object);
        } else if (object instanceof Character) {
            ((ArrayNode)this.node).add((int)((Character)object).charValue());
        } else if (object instanceof Byte) {
            ((ArrayNode)this.node).add((int)((Byte)object).byteValue());
        } else {
            ((ArrayNode)this.node).add(object.toString());
        }
    }

    private Optional<Function> mapFunction(Optional<String> mapFunctionValueOptional, DataModel dataModel) {
        if (mapFunctionValueOptional.isPresent()) {
            String mapFunctionValue = mapFunctionValueOptional.get();
            Optional<Object> mapFunctionOptional = dataModel.getData(mapFunctionValue);
            Object obj = mapFunctionOptional.orElseGet(() -> {
                try {
                    return Class.forName(mapFunctionValue).newInstance();
                }
                catch (ClassNotFoundException e) {
                    throw new JsonviewException(String.format("The mapFunction's Class \"%s\" not found, and it's also not a expression.", mapFunctionValue));
                }
                catch (IllegalAccessException | InstantiationException e) {
                    throw new JsonviewException("Can't new mapFunction instance.");
                }
            });
            if (obj instanceof Function) {
                return Optional.of((Function)obj);
            }
            throw new JsonviewException(String.format("\"%s\" is not a Function instance.", obj.toString()));
        }
        return Optional.empty();
    }
}

