/*
 * Decompiled with CFR 0.152.
 */
package com.github.developframework.jsonview.core.processor;

import com.github.developframework.jsonview.core.element.PropertyElement;
import com.github.developframework.jsonview.core.processor.Context;
import com.github.developframework.jsonview.core.processor.LinkProcessor;
import com.github.developframework.jsonview.core.processor.NormalPropertyProcessor;
import com.github.developframework.jsonview.data.Expression;
import com.github.developframework.jsonview.exception.LinkObjectSizeNotEqualException;
import java.util.Collection;
import java.util.List;
import java.util.Optional;

public class LinkPropertyProcessor
extends NormalPropertyProcessor
implements LinkProcessor {
    private int index;

    public LinkPropertyProcessor(Context context, PropertyElement element, Expression parentExpression) {
        super(context, element, parentExpression);
    }

    @Override
    public void checkSize(int parentArraySize) {
        Optional<Object> objOptional = this.context.getDataModel().getData(this.expression);
        if (objOptional.isPresent()) {
            int size = 0;
            Object obj = objOptional.get();
            if (obj.getClass().isArray()) {
                size = ((Object[])obj).length;
            } else if (obj instanceof Collection) {
                size = ((List)obj).size();
            }
            if (size != parentArraySize) {
                throw new LinkObjectSizeNotEqualException(((PropertyElement)this.element).getData());
            }
        }
    }

    @Override
    public void setIndex(int index) {
        this.index = index;
        this.expression = Expression.buildArrayExpression(this.expression, index);
    }

    public int getIndex() {
        return this.index;
    }
}

