/*
 * Decompiled with CFR 0.152.
 */
package com.github.developframework.jsonview.core.processor;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.developframework.jsonview.core.element.ArrayElement;
import com.github.developframework.jsonview.core.element.Element;
import com.github.developframework.jsonview.core.element.MappingObjectElement;
import com.github.developframework.jsonview.core.element.ObjectElement;
import com.github.developframework.jsonview.core.processor.ArrayProcessor;
import com.github.developframework.jsonview.core.processor.Context;
import com.github.developframework.jsonview.core.processor.DescribeContentProcessor;
import com.github.developframework.jsonview.core.processor.ObjectProcessor;
import com.github.developframework.jsonview.data.Expression;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class MappingObjectProcessor
extends ObjectProcessor {
    private String target;
    private Object sourceValue;

    public MappingObjectProcessor(Context context, MappingObjectElement element, Expression parentExpression) {
        super(context, element, parentExpression);
        this.target = element.getTarget();
    }

    public void setParentArrayExpression(Expression parentArrayExpression) {
        MappingObjectElement mappingObjectElement = (MappingObjectElement)this.element;
        Expression expression = Expression.concatExpression(parentArrayExpression, mappingObjectElement.getSource());
        Optional<Object> valueOptional = this.context.getDataModel().getData(expression);
        valueOptional.ifPresent(v -> {
            this.sourceValue = v;
        });
    }

    @Override
    public void process(DescribeContentProcessor<? extends Element, ? extends JsonNode> parentProcessor) {
        if (Objects.nonNull(this.sourceValue)) {
            Optional<List<Expression>> optional = this.context.getDataModel().getData(this.expression, this.target, this.sourceValue);
            optional.ifPresent(list -> {
                MappingObjectElement mappingObjectElement = (MappingObjectElement)this.element;
                switch (mappingObjectElement.getMappingType()) {
                    case MULTIPLE: {
                        this.arrayProcess(parentProcessor, (List<Expression>)list, mappingObjectElement);
                        break;
                    }
                    case SINGLE: {
                        this.objectProcess(parentProcessor, (List<Expression>)list, mappingObjectElement);
                        break;
                    }
                    case AUTO: {
                        if (list.size() == 1) {
                            this.objectProcess(parentProcessor, (List<Expression>)list, mappingObjectElement);
                            break;
                        }
                        this.arrayProcess(parentProcessor, (List<Expression>)list, mappingObjectElement);
                    }
                }
            });
        }
    }

    private void objectProcess(DescribeContentProcessor<? extends Element, ? extends JsonNode> parentProcessor, List<Expression> list, MappingObjectElement mappingObjectElement) {
        ObjectElement objectElement = mappingObjectElement.getChildObjectElement();
        objectElement.setData(list.get(0).toString());
        objectElement.createProcessor(this.context, (ObjectNode)parentProcessor.getNode(), null).ifPresent(processor -> processor.process(parentProcessor));
    }

    private void arrayProcess(DescribeContentProcessor<? extends Element, ? extends JsonNode> parentProcessor, List<Expression> list, MappingObjectElement mappingObjectElement) {
        ArrayElement arrayElement = mappingObjectElement.getChildArrayElement();
        arrayElement.createProcessor(this.context, (ObjectNode)parentProcessor.getNode(), null).ifPresent(processor -> ((ArrayProcessor)processor).process(parentProcessor, list));
    }

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public Object getSourceValue() {
        return this.sourceValue;
    }

    public void setSourceValue(Object sourceValue) {
        this.sourceValue = sourceValue;
    }
}

