/*
 * Decompiled with CFR 0.152.
 */
package com.github.developframework.jsonview.core.processor;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.developframework.jsonview.core.converter.PropertyConverter;
import com.github.developframework.jsonview.core.element.Element;
import com.github.developframework.jsonview.core.element.PropertyElement;
import com.github.developframework.jsonview.core.processor.Context;
import com.github.developframework.jsonview.core.processor.DescribeContentProcessor;
import com.github.developframework.jsonview.data.DataModel;
import com.github.developframework.jsonview.data.Expression;
import com.github.developframework.jsonview.exception.JsonviewException;
import java.util.Optional;

public abstract class PropertyProcessor
extends DescribeContentProcessor<PropertyElement, JsonNode> {
    public PropertyProcessor(Context context, PropertyElement element, Expression parentExpression) {
        super(context, element, parentExpression);
    }

    @Override
    protected final void process(DescribeContentProcessor<? extends Element, ? extends JsonNode> parentNodeProcessor) {
        DataModel dataModel = parentNodeProcessor.getContext().getDataModel();
        Optional<Object> valueOptional = dataModel.getData(this.expression);
        ObjectNode parentNode = (ObjectNode)parentNodeProcessor.getNode();
        String showName = ((PropertyElement)this.element).showName();
        if (!valueOptional.isPresent()) {
            if (!((PropertyElement)this.element).isNullHidden()) {
                parentNode.putNull(showName);
            }
            return;
        }
        valueOptional.ifPresent(value -> {
            Optional<Object> optional = ((PropertyElement)this.element).getConverterValue().map(converterValue -> {
                Optional<Object> converterOptional = dataModel.getData((String)converterValue);
                Object obj = converterOptional.orElseGet(() -> {
                    try {
                        return Class.forName(converterValue).newInstance();
                    }
                    catch (ClassNotFoundException e) {
                        throw new JsonviewException(String.format("The converter's Class \"%s\" not found, and it's also not a expression.", converterValue));
                    }
                    catch (IllegalAccessException | InstantiationException e) {
                        throw new JsonviewException("Can't new converter instance.");
                    }
                });
                if (obj instanceof PropertyConverter) {
                    return ((PropertyConverter)obj).convert(value);
                }
                throw new JsonviewException(String.format("\"%s\" is not a PropertyConverter instance.", obj.toString()));
            });
            Object newValue = optional.orElse(value);
            Class<?> valueClass = newValue.getClass();
            if (this.support(valueClass)) {
                this.handle(parentNode, valueClass, newValue, showName);
            }
        });
    }

    protected abstract boolean support(Class<?> var1);

    protected abstract void handle(ObjectNode var1, Class<?> var2, Object var3, String var4);
}

