/*
 * Decompiled with CFR 0.152.
 */
package com.github.developframework.jsonview.core;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.developframework.jsonview.core.JsonProducer;
import com.github.developframework.jsonview.core.JsonviewConfiguration;
import com.github.developframework.jsonview.core.data.DataDefinition;
import com.github.developframework.jsonview.core.data.DataModel;
import com.github.developframework.jsonview.core.element.ArrayElement;
import com.github.developframework.jsonview.core.element.JsonviewTemplate;
import com.github.developframework.jsonview.core.exception.JsonviewException;
import com.github.developframework.jsonview.core.processor.ArrayTemplateProcessor;
import com.github.developframework.jsonview.core.processor.ProcessContext;
import com.github.developframework.jsonview.core.processor.TemplateProcessor;
import java.util.List;
import java.util.Optional;

class DefaultJsonProducer
implements JsonProducer {
    private JsonviewConfiguration jsonviewConfiguration;

    DefaultJsonProducer(JsonviewConfiguration jsonviewConfiguration) {
        this.jsonviewConfiguration = jsonviewConfiguration;
    }

    @Override
    public String createJson(DataModel dataModel, String namespace, String templateId) {
        return this.createJson(dataModel, namespace, templateId, false);
    }

    @Override
    public String createJson(DataModel dataModel, String namespace, String templateId, boolean isPretty) {
        JsonNode root = this.constructRootTree(dataModel, namespace, templateId);
        try {
            if (isPretty) {
                return this.jsonviewConfiguration.getObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)root);
            }
            return this.jsonviewConfiguration.getObjectMapper().writeValueAsString((Object)root);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public void printJson(JsonGenerator jsonGenerator, DataModel dataModel, String namespace, String templateId) {
        JsonNode root = this.constructRootTree(dataModel, namespace, templateId);
        try {
            this.jsonviewConfiguration.getObjectMapper().writeValue(jsonGenerator, (Object)root);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private JsonNode constructRootTree(DataModel dataModel, String namespace, String id) {
        JsonviewTemplate jsonviewTemplate = this.jsonviewConfiguration.extractTemplate(namespace, id);
        ProcessContext processContext = new ProcessContext();
        processContext.setDataModel(dataModel);
        processContext.setJsonviewConfiguration(this.jsonviewConfiguration);
        DataDefinition templateDataDefinition = jsonviewTemplate.getDataDefinition();
        if (templateDataDefinition != null) {
            Optional<Object> rootObjectOptional = dataModel.getData(templateDataDefinition.getExpression());
            if (rootObjectOptional.isPresent()) {
                Object rootObject = rootObjectOptional.get();
                if (rootObject.getClass().isArray() || rootObject instanceof List) {
                    return this.constructRootArrayNodeTree(processContext, jsonviewTemplate, rootObject);
                }
                return this.constructRootObjectNodeTree(processContext, jsonviewTemplate, rootObject);
            }
            throw new JsonviewException("Root data must not null.");
        }
        return this.constructRootObjectNodeTree(processContext, jsonviewTemplate, null);
    }

    private ObjectNode constructRootObjectNodeTree(ProcessContext processContext, JsonviewTemplate jsonviewTemplate, Object value) {
        ObjectNode rootNode = this.jsonviewConfiguration.getObjectMapper().createObjectNode();
        TemplateProcessor templateProcessor = new TemplateProcessor(processContext, jsonviewTemplate, jsonviewTemplate.getDataDefinition().getExpression());
        templateProcessor.setValue(value);
        templateProcessor.setNode(rootNode);
        templateProcessor.process(null);
        return rootNode;
    }

    private ArrayNode constructRootArrayNodeTree(ProcessContext processContext, JsonviewTemplate jsonviewTemplate, Object value) {
        ArrayNode rootNode = this.jsonviewConfiguration.getObjectMapper().createArrayNode();
        ArrayElement arrayElement = new ArrayElement(this.jsonviewConfiguration, jsonviewTemplate.getNamespace(), jsonviewTemplate.getTemplateId(), jsonviewTemplate.getDataDefinition(), null);
        arrayElement.setMapFunctionValue(jsonviewTemplate.getMapFunctionValue());
        ArrayTemplateProcessor arrayProcessor = new ArrayTemplateProcessor(processContext, jsonviewTemplate, arrayElement);
        arrayProcessor.setValue(value);
        arrayProcessor.setNode(rootNode);
        arrayProcessor.process(null);
        return rootNode;
    }
}

