/*
 * Decompiled with CFR 0.152.
 */
package com.github.developframework.jsonview.core;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.developframework.jsonview.core.element.JsonviewTemplate;
import com.github.developframework.jsonview.core.element.JsonviewTemplatePackage;
import com.github.developframework.jsonview.core.exception.ResourceNotUniqueException;
import com.github.developframework.jsonview.core.exception.TemplatePackageUndefinedException;
import java.util.HashMap;
import java.util.Map;

public class JsonviewConfiguration {
    private ObjectMapper objectMapper;
    private Map<String, JsonviewTemplatePackage> templatePackages = new HashMap<String, JsonviewTemplatePackage>();

    public void putTemplatePackage(JsonviewTemplatePackage jsonviewTemplatePackage) {
        String namespace = jsonviewTemplatePackage.getNamespace();
        if (this.templatePackages.containsKey(namespace)) {
            throw new ResourceNotUniqueException("Jsonview package", namespace);
        }
        this.templatePackages.put(namespace, jsonviewTemplatePackage);
    }

    public JsonviewTemplatePackage getTemplatePackageByNamespace(String namespace) {
        JsonviewTemplatePackage jsonviewTemplatePackage = this.templatePackages.get(namespace);
        if (jsonviewTemplatePackage == null) {
            throw new TemplatePackageUndefinedException(namespace);
        }
        return jsonviewTemplatePackage;
    }

    public JsonviewTemplate extractTemplate(String namespace, String templateId) {
        return this.getTemplatePackageByNamespace(namespace).getJsonviewTemplateById(templateId);
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }
}

