/*
 * Decompiled with CFR 0.152.
 */
package com.github.developframework.jsonview.core.element;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.developframework.expression.Expression;
import com.github.developframework.jsonview.core.JsonviewConfiguration;
import com.github.developframework.jsonview.core.data.DataDefinition;
import com.github.developframework.jsonview.core.element.ContainerElement;
import com.github.developframework.jsonview.core.element.Element;
import com.github.developframework.jsonview.core.element.ObjectElement;
import com.github.developframework.jsonview.core.processor.ArrayProcessor;
import com.github.developframework.jsonview.core.processor.ProcessContext;
import com.github.developframework.jsonview.core.processor.Processor;
import java.util.Optional;

public class ArrayElement
extends ContainerElement {
    private ObjectElement itemObjectElement;
    private String mapFunctionValue;

    public ArrayElement(JsonviewConfiguration configuration, String namespace, String templateId, DataDefinition dataDefinition, String alias) {
        super(configuration, namespace, templateId, dataDefinition, alias);
        this.itemObjectElement = new ObjectElement(configuration, namespace, templateId, dataDefinition, alias);
    }

    @Override
    public Processor<? extends Element, ? extends JsonNode> createProcessor(ProcessContext processContext, ObjectNode parentNode, Expression parentExpression) {
        return new ArrayProcessor(processContext, this, Processor.childExpression(this, parentExpression));
    }

    @Override
    public void addChildElement(Element element) {
        super.addChildElement(element);
        this.itemObjectElement.addChildElement(element);
    }

    @Override
    public void copyChildElement(ContainerElement otherContainerElement) {
        super.copyChildElement(otherContainerElement);
        this.itemObjectElement.copyChildElement(otherContainerElement);
    }

    public Optional<String> getMapFunctionValueOptional() {
        return Optional.ofNullable(this.mapFunctionValue);
    }

    public ObjectElement getItemObjectElement() {
        return this.itemObjectElement;
    }

    public void setMapFunctionValue(String mapFunctionValue) {
        this.mapFunctionValue = mapFunctionValue;
    }
}

