/*
 * Decompiled with CFR 0.152.
 */
package com.github.developframework.jsonview.core.element;

import com.github.developframework.jsonview.core.JsonviewConfiguration;
import com.github.developframework.jsonview.core.data.DataDefinition;
import com.github.developframework.jsonview.core.element.ContainChildElementable;
import com.github.developframework.jsonview.core.element.ContentElement;
import com.github.developframework.jsonview.core.element.Element;
import com.github.developframework.jsonview.core.element.NormalPropertyElement;
import com.github.developframework.jsonview.core.exception.JsonviewParseXmlException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public abstract class ContainerElement
extends ContentElement
implements ContainChildElementable {
    protected List<Element> childElements = new ArrayList<Element>();
    protected Class<?> forClass;
    protected List<String> ignorePropertyNames = new ArrayList<String>();

    public ContainerElement(JsonviewConfiguration configuration, String namespace, String templateId, DataDefinition dataDefinition, String alias) {
        super(configuration, namespace, templateId, dataDefinition, alias);
    }

    public void setForClass(String className) {
        if (StringUtils.isNotBlank((CharSequence)className)) {
            try {
                this.forClass = Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                throw new JsonviewParseXmlException("Class \"%s\" is not found, please check configuration file.", className);
            }
        }
    }

    public final void addIgnoreProperty(String propertyName) {
        this.ignorePropertyNames.add(propertyName);
    }

    public final void loadForClassAllProperty() {
        if (this.forClass != null) {
            Field[] fields;
            for (Field field : fields = this.forClass.getDeclaredFields()) {
                if (this.ignorePropertyNames.contains(field.getName())) continue;
                DataDefinition dataDefinition = new DataDefinition(field.getName());
                NormalPropertyElement propertyElement = new NormalPropertyElement(this.configuration, this.getNamespace(), this.getTemplateId(), dataDefinition, null);
                if (this.childElements.contains(propertyElement)) continue;
                this.addChildElement(propertyElement);
            }
        }
    }

    public void copyChildElement(ContainerElement otherContainerElement) {
        this.childElements.addAll(otherContainerElement.getChildElements());
        this.ignorePropertyNames.addAll(otherContainerElement.ignorePropertyNames);
        this.alias = otherContainerElement.alias;
        this.forClass = otherContainerElement.forClass;
        this.nullHidden = otherContainerElement.nullHidden;
        this.namespace = otherContainerElement.namespace;
        this.templateId = otherContainerElement.templateId;
    }

    @Override
    public void addChildElement(Element element) {
        this.childElements.add(element);
    }

    @Override
    public final void copyChildElement(ContainChildElementable otherContainer) {
        this.childElements.addAll(otherContainer.getChildElements());
    }

    @Override
    public final Iterator<Element> childElementIterator() {
        return this.childElements.iterator();
    }

    @Override
    public final boolean isChildElementEmpty() {
        return this.childElements.isEmpty();
    }

    @Override
    public final List<Element> getChildElements() {
        return this.childElements;
    }

    public Class<?> getForClass() {
        return this.forClass;
    }
}

