/*
 * Decompiled with CFR 0.152.
 */
package com.github.developframework.jsonview.core.element;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.developframework.expression.Expression;
import com.github.developframework.jsonview.core.JsonviewConfiguration;
import com.github.developframework.jsonview.core.element.DuplicateTemplateElement;
import com.github.developframework.jsonview.core.element.Element;
import com.github.developframework.jsonview.core.element.ObjectElement;
import com.github.developframework.jsonview.core.processor.ProcessContext;
import com.github.developframework.jsonview.core.processor.Processor;
import com.github.developframework.jsonview.core.processor.TemplateProcessor;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public class JsonviewTemplate
extends ObjectElement {
    private Extend extend;
    private String mapFunctionValue;

    public JsonviewTemplate(JsonviewConfiguration configuration, String namespace, String templateId) {
        super(configuration, namespace, templateId, null, null);
    }

    @Override
    public Processor<? extends Element, ? extends JsonNode> createProcessor(ProcessContext processContext, ObjectNode parentNode, Expression parentExpression) {
        TemplateProcessor templateProcessor = new TemplateProcessor(processContext, this, Processor.childExpression(this, parentExpression));
        templateProcessor.setNode(parentNode);
        return templateProcessor;
    }

    public Optional<Extend> getExtend() {
        return Optional.ofNullable(this.extend);
    }

    public DuplicateTemplateElement createDuplicateTemplateElement() {
        return new DuplicateTemplateElement(this.configuration, this);
    }

    public String getMapFunctionValue() {
        return this.mapFunctionValue;
    }

    public void setExtend(Extend extend) {
        this.extend = extend;
    }

    public void setMapFunctionValue(String mapFunctionValue) {
        this.mapFunctionValue = mapFunctionValue;
    }

    public class Extend {
        private String namespace;
        private String templateId;
        private String port;

        public Extend(String extendValue, String defaultNamespace) {
            String front = StringUtils.substringBefore((String)extendValue, (String)":");
            this.port = StringUtils.substringAfter((String)extendValue, (String)":");
            if (front.contains(".")) {
                this.namespace = StringUtils.substringBefore((String)front, (String)".");
                this.templateId = StringUtils.substringAfter((String)front, (String)".");
            } else {
                this.namespace = defaultNamespace;
                this.templateId = front;
            }
        }

        public String getNamespace() {
            return this.namespace;
        }

        public String getTemplateId() {
            return this.templateId;
        }

        public String getPort() {
            return this.port;
        }
    }
}

