/*
 * Decompiled with CFR 0.152.
 */
package com.github.developframework.jsonview.core.element;

import com.github.developframework.jsonview.core.element.JsonviewTemplate;
import com.github.developframework.jsonview.core.exception.ResourceNotUniqueException;
import com.github.developframework.jsonview.core.exception.TemplateUndefinedException;
import java.util.HashMap;

public class JsonviewTemplatePackage
extends HashMap<String, JsonviewTemplate> {
    private String namespace;

    public JsonviewTemplatePackage(String namespace) {
        this.namespace = namespace;
    }

    public JsonviewTemplate getJsonviewTemplateById(String templateId) {
        JsonviewTemplate jsonviewTemplate = (JsonviewTemplate)super.get(templateId);
        if (jsonviewTemplate == null) {
            throw new TemplateUndefinedException(this.namespace, templateId);
        }
        return jsonviewTemplate;
    }

    public void push(JsonviewTemplate jsonviewTemplate) {
        String templateId = jsonviewTemplate.getTemplateId();
        if (super.containsKey(templateId)) {
            throw new ResourceNotUniqueException("Jsonview template", templateId);
        }
        super.put(templateId, jsonviewTemplate);
    }

    public String getNamespace() {
        return this.namespace;
    }
}

