/*
 * Decompiled with CFR 0.152.
 */
package com.github.developframework.jsonview.core.element;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.developframework.expression.Expression;
import com.github.developframework.jsonview.core.JsonviewConfiguration;
import com.github.developframework.jsonview.core.data.DataDefinition;
import com.github.developframework.jsonview.core.element.ArrayElement;
import com.github.developframework.jsonview.core.element.Element;
import com.github.developframework.jsonview.core.processor.ProcessContext;
import com.github.developframework.jsonview.core.processor.Processor;
import com.github.developframework.jsonview.core.processor.RelevanceProcessor;
import org.apache.commons.lang3.StringUtils;

public class RelevanceElement
extends ArrayElement {
    private String relFunctionValue;
    private RelevanceType relevanceType;

    public RelevanceElement(JsonviewConfiguration configuration, String namespace, String templateId, DataDefinition dataDefinition, String alias) {
        super(configuration, namespace, templateId, dataDefinition, alias);
    }

    @Override
    public Processor<? extends Element, ? extends JsonNode> createProcessor(ProcessContext processContext, ObjectNode parentNode, Expression parentExpression) {
        return new RelevanceProcessor(processContext, this, parentExpression);
    }

    public void setRelevanceType(String relevanceTypeValue) {
        this.relevanceType = StringUtils.isNotBlank((CharSequence)relevanceTypeValue) ? RelevanceType.valueOf(relevanceTypeValue.toUpperCase()) : RelevanceType.AUTO;
    }

    public String getRelFunctionValue() {
        return this.relFunctionValue;
    }

    public RelevanceType getRelevanceType() {
        return this.relevanceType;
    }

    public void setRelFunctionValue(String relFunctionValue) {
        this.relFunctionValue = relFunctionValue;
    }

    public static enum RelevanceType {
        AUTO,
        SINGLE,
        MULTIPLE;

    }
}

