/*
 * Decompiled with CFR 0.152.
 */
package com.github.developframework.jsonview.core.processor;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.developframework.expression.Expression;
import com.github.developframework.jsonview.core.element.PropertyElement;
import com.github.developframework.jsonview.core.processor.ProcessContext;
import com.github.developframework.jsonview.core.processor.PropertyProcessor;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class DatePropertyProcessor
extends PropertyProcessor {
    private DateFormat dateFormat;
    private static final Set<Class<?>> ACCEPT_CLASS_SET = new HashSet(9);

    public DatePropertyProcessor(ProcessContext processContext, PropertyElement element, Expression parentExpression) {
        this(processContext, element, parentExpression, (String)null);
    }

    public DatePropertyProcessor(ProcessContext processContext, PropertyElement element, Expression parentExpression, String pattern) {
        super(processContext, element, parentExpression);
        this.dateFormat = new SimpleDateFormat(StringUtils.isBlank((CharSequence)pattern) ? "yyyy-MM-dd HH:mm:ss" : pattern);
    }

    @Override
    protected boolean support(Class<?> sourceClass) {
        return ACCEPT_CLASS_SET.contains(sourceClass);
    }

    @Override
    protected void handle(ObjectNode parentNode, Class<?> clazz, Object value, String showName) {
        java.util.Date date = this.transformDate(clazz, value);
        if (Objects.isNull(date)) {
            parentNode.putNull(showName);
            return;
        }
        parentNode.put(showName, this.dateFormat.format(date));
    }

    protected java.util.Date transformDate(Class<?> clazz, Object value) {
        java.util.Date date = null;
        if (clazz == java.util.Date.class) {
            date = (java.util.Date)value;
        } else if (clazz == Calendar.class) {
            date = ((Calendar)value).getTime();
        } else if (clazz == Date.class) {
            date = new java.util.Date(((Date)value).getTime());
        } else if (clazz == Time.class) {
            date = new java.util.Date(((Time)value).getTime());
        } else if (clazz == Timestamp.class) {
            date = new java.util.Date(((Timestamp)value).getTime());
        } else if (clazz == LocalDateTime.class) {
            date = java.util.Date.from(((LocalDateTime)value).atZone(ZoneId.systemDefault()).toInstant());
        } else if (clazz == LocalDate.class) {
            LocalTime localTime = LocalTime.parse("00:00:00");
            LocalDateTime localDateTime = LocalDateTime.of((LocalDate)value, localTime);
            date = java.util.Date.from(localDateTime.atZone(ZoneId.systemDefault()).toInstant());
        } else if (clazz == LocalTime.class) {
            LocalDate localDate = LocalDate.now();
            LocalDateTime localDateTime = LocalDateTime.of(localDate, (LocalTime)value);
            date = java.util.Date.from(localDateTime.atZone(ZoneId.systemDefault()).toInstant());
        } else if (clazz == Instant.class) {
            date = java.util.Date.from((Instant)value);
        }
        return date;
    }

    static {
        ACCEPT_CLASS_SET.add(java.util.Date.class);
        ACCEPT_CLASS_SET.add(Calendar.class);
        ACCEPT_CLASS_SET.add(Date.class);
        ACCEPT_CLASS_SET.add(Time.class);
        ACCEPT_CLASS_SET.add(Timestamp.class);
        ACCEPT_CLASS_SET.add(LocalDate.class);
        ACCEPT_CLASS_SET.add(LocalDateTime.class);
        ACCEPT_CLASS_SET.add(LocalTime.class);
        ACCEPT_CLASS_SET.add(Instant.class);
    }
}

