/*
 * Decompiled with CFR 0.152.
 */
package com.github.developframework.jsonview.core.processor;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.developframework.expression.ArrayExpression;
import com.github.developframework.expression.Expression;
import com.github.developframework.expression.ObjectExpression;
import com.github.developframework.jsonview.core.element.ContentElement;
import com.github.developframework.jsonview.core.element.Element;
import com.github.developframework.jsonview.core.element.LinkElement;
import com.github.developframework.jsonview.core.element.ObjectElement;
import com.github.developframework.jsonview.core.exception.InvalidArgumentsException;
import com.github.developframework.jsonview.core.exception.LinkSizeNotEqualException;
import com.github.developframework.jsonview.core.processor.ContentProcessor;
import com.github.developframework.jsonview.core.processor.ObjectInArrayProcessor;
import com.github.developframework.jsonview.core.processor.ObjectProcessor;
import com.github.developframework.jsonview.core.processor.ProcessContext;
import com.github.developframework.jsonview.core.processor.Processor;
import java.util.Collection;
import java.util.Optional;

public class LinkProcessor
extends ObjectProcessor {
    public LinkProcessor(ProcessContext processContext, LinkElement element, Expression parentExpression) {
        super(processContext, element, parentExpression);
    }

    @Override
    protected boolean prepare(ContentProcessor<? extends Element, ? extends JsonNode> parentProcessor) {
        ObjectInArrayProcessor objectInArrayProcessor = (ObjectInArrayProcessor)parentProcessor;
        Optional<Object> valueOptional = this.processContext.getDataModel().getData(this.expression);
        if (valueOptional.isPresent()) {
            int size;
            this.value = valueOptional.get();
            if (this.value.getClass().isArray()) {
                size = ((Object[])this.value).length;
            } else if (this.value instanceof Collection) {
                size = ((Collection)this.value).size();
            } else {
                throw new InvalidArgumentsException("data", this.expression.toString(), "Data must be array or List type.");
            }
            if (size != objectInArrayProcessor.getSize()) {
                throw new LinkSizeNotEqualException(((ObjectElement)this.element).getNamespace(), ((ObjectElement)this.element).getTemplateId());
            }
            return true;
        }
        if (!((ObjectElement)this.element).isNullHidden()) {
            ((ObjectNode)this.node).putNull(((ObjectElement)this.element).showName());
        }
        return false;
    }

    @Override
    protected void handleCoreLogic(ContentProcessor<? extends Element, ? extends JsonNode> parentProcessor) {
        ObjectInArrayProcessor objectInArrayProcessor = (ObjectInArrayProcessor)parentProcessor;
        ArrayExpression arrayExpression = (ArrayExpression)objectInArrayProcessor.getExpression();
        ArrayExpression targetExpression = new ArrayExpression(((ObjectExpression)this.expression).getPropertyName(), arrayExpression.getIndex());
        ContentElement contentElement = ((LinkElement)this.element).createProxyContentElement();
        Processor<? extends Element, ? extends JsonNode> nextProcessor = contentElement.createProcessor(this.processContext, (ObjectNode)objectInArrayProcessor.node, (Expression)targetExpression);
        nextProcessor.process(parentProcessor);
    }
}

