/*
 * Decompiled with CFR 0.152.
 */
package com.github.developframework.jsonview.core.processor;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.developframework.expression.Expression;
import com.github.developframework.jsonview.core.data.DataDefinition;
import com.github.developframework.jsonview.core.data.FunctionSign;
import com.github.developframework.jsonview.core.element.ContentElement;
import com.github.developframework.jsonview.core.element.Element;
import com.github.developframework.jsonview.core.processor.ContentProcessor;
import com.github.developframework.jsonview.core.processor.ProcessContext;

public abstract class Processor<ELEMENT extends Element, NODE extends JsonNode> {
    protected ProcessContext processContext;
    protected ELEMENT element;
    protected NODE node;
    protected Expression expression;
    protected Object value;

    public Processor(ProcessContext processContext, ELEMENT element, NODE node, Expression expression) {
        this.processContext = processContext;
        this.element = element;
        this.node = node;
        this.expression = expression;
    }

    public static Expression childExpression(ContentElement contentElement, Expression parentExpression) {
        DataDefinition dataDefinition = contentElement.getDataDefinition();
        if (dataDefinition.getFunctionSign() == FunctionSign.ROOT) {
            return dataDefinition.getExpression();
        }
        if (parentExpression == null) {
            return dataDefinition.getExpression();
        }
        return Expression.concat((Expression)parentExpression, (Expression)dataDefinition.getExpression());
    }

    protected abstract boolean prepare(ContentProcessor<? extends Element, ? extends JsonNode> var1);

    protected abstract void handleCoreLogic(ContentProcessor<? extends Element, ? extends JsonNode> var1);

    public final void process(ContentProcessor<? extends Element, ? extends JsonNode> parentProcessor) {
        if (this.prepare(parentProcessor)) {
            this.handleCoreLogic(parentProcessor);
        }
    }

    public ProcessContext getProcessContext() {
        return this.processContext;
    }

    public ELEMENT getElement() {
        return this.element;
    }

    public NODE getNode() {
        return this.node;
    }

    public Expression getExpression() {
        return this.expression;
    }

    public Object getValue() {
        return this.value;
    }

    public void setNode(NODE node) {
        this.node = node;
    }

    public void setValue(Object value) {
        this.value = value;
    }
}

