/*
 * Decompiled with CFR 0.152.
 */
package com.github.developframework.jsonview.core.processor;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.developframework.expression.ArrayExpression;
import com.github.developframework.expression.Expression;
import com.github.developframework.expression.ObjectExpression;
import com.github.developframework.jsonview.core.data.DataDefinition;
import com.github.developframework.jsonview.core.dynamic.RelFunction;
import com.github.developframework.jsonview.core.element.ArrayElement;
import com.github.developframework.jsonview.core.element.ContainerElement;
import com.github.developframework.jsonview.core.element.Element;
import com.github.developframework.jsonview.core.element.ProxyObjectElement;
import com.github.developframework.jsonview.core.element.RelevanceElement;
import com.github.developframework.jsonview.core.exception.InvalidArgumentsException;
import com.github.developframework.jsonview.core.exception.JsonviewException;
import com.github.developframework.jsonview.core.processor.ArrayProcessor;
import com.github.developframework.jsonview.core.processor.ContentProcessor;
import com.github.developframework.jsonview.core.processor.ObjectInArrayProcessor;
import com.github.developframework.jsonview.core.processor.ProcessContext;
import com.github.developframework.jsonview.core.processor.Processor;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RelevanceProcessor
extends ArrayProcessor {
    private static final Logger log = LoggerFactory.getLogger(RelevanceProcessor.class);

    public RelevanceProcessor(ProcessContext processContext, RelevanceElement element, Expression parentExpression) {
        super(processContext, element, parentExpression);
    }

    @Override
    protected boolean prepare(ContentProcessor<? extends Element, ? extends JsonNode> parentProcessor) {
        Optional<Object> valueOptional = this.processContext.getDataModel().getData(((ArrayElement)this.element).getDataDefinition().getExpression());
        if (valueOptional.isPresent()) {
            this.value = valueOptional.get();
            return true;
        }
        if (!((ArrayElement)this.element).isNullHidden()) {
            ((ObjectNode)parentProcessor.getNode()).putNull(((ArrayElement)this.element).showName());
        }
        return false;
    }

    @Override
    protected void handleCoreLogic(ContentProcessor<? extends Element, ? extends JsonNode> parentProcessor) {
        ObjectInArrayProcessor objectInArrayProcessor = (ObjectInArrayProcessor)parentProcessor;
        ArrayExpression arrayExpression = (ArrayExpression)objectInArrayProcessor.getExpression();
        Optional<Object> itemOptional = this.processContext.getDataModel().getData((Expression)arrayExpression);
        if (itemOptional.isPresent()) {
            RelFunction relFunction = this.getRelFunctionInstance(((RelevanceElement)this.element).getRelFunctionValue());
            Object[] targets = this.getTargets();
            LinkedList<Integer> indexList = new LinkedList<Integer>();
            for (int i = 0; i < targets.length; ++i) {
                if (!relFunction.relevant(itemOptional.get(), arrayExpression.getIndex(), targets[i], i)) continue;
                indexList.add(i);
            }
            ObjectExpression targetExpression = (ObjectExpression)((ArrayElement)this.element).getDataDefinition().getExpression();
            List<ArrayExpression> arrayExpressions = indexList.stream().map(index -> new ArrayExpression(targetExpression.getPropertyName(), index.intValue())).collect(Collectors.toList());
            this.typeStrategy(parentProcessor, arrayExpressions, targetExpression);
        }
    }

    private RelFunction getRelFunctionInstance(String relFunctionValue) {
        Optional<Object> converterOptional = this.processContext.getDataModel().getData(relFunctionValue);
        return (RelFunction)converterOptional.orElseGet(() -> {
            try {
                Object obj = Class.forName(relFunctionValue).newInstance();
                if (obj instanceof RelFunction) {
                    return obj;
                }
                throw new InvalidArgumentsException("rel-function", relFunctionValue, "It's not a RelFunction instance.");
            }
            catch (ClassNotFoundException e) {
                throw new InvalidArgumentsException("rel-function", relFunctionValue, "class not found, and it's also not a expression.");
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new JsonviewException("Can't new RelFunction instance.");
            }
        });
    }

    private Object[] getTargets() {
        Class<?> targetClass = this.value.getClass();
        if (targetClass.isArray()) {
            return (Object[])this.value;
        }
        if (List.class.isAssignableFrom(targetClass)) {
            List list = (List)this.value;
            Object[] array = new Object[list.size()];
            return list.toArray(array);
        }
        throw new InvalidArgumentsException("data", this.expression.toString(), "The data must be array or list type.");
    }

    private void typeStrategy(ContentProcessor<? extends Element, ? extends JsonNode> parentProcessor, List<ArrayExpression> arrayExpressions, ObjectExpression targetExpression) {
        switch (((RelevanceElement)this.element).getRelevanceType()) {
            case AUTO: {
                if (arrayExpressions.size() == 1) {
                    this.generateObjectStructure(parentProcessor, arrayExpressions);
                    break;
                }
                this.generateArrayStructure(parentProcessor, arrayExpressions);
                break;
            }
            case SINGLE: {
                if (arrayExpressions.size() > 1) {
                    log.warn("You have more items in {}, and you choose relevance type \"SINGLE\".", (Object)targetExpression.toString());
                }
                this.generateObjectStructure(parentProcessor, arrayExpressions);
                break;
            }
            case MULTIPLE: {
                this.generateArrayStructure(parentProcessor, arrayExpressions);
            }
        }
    }

    private void generateObjectStructure(ContentProcessor<? extends Element, ? extends JsonNode> parentProcessor, List<ArrayExpression> arrayExpressions) {
        Expression targetExpression = (Expression)arrayExpressions.get(0);
        DataDefinition dataDefinition = new DataDefinition(null, targetExpression);
        ProxyObjectElement proxyObjectElement = new ProxyObjectElement(this.processContext.getJsonviewConfiguration(), (ContainerElement)this.element, dataDefinition);
        proxyObjectElement.copyChildElement((ContainerElement)this.element);
        Processor<? extends Element, ? extends JsonNode> processor = proxyObjectElement.createProcessor(this.processContext, null, targetExpression);
        processor.process(parentProcessor);
    }

    private void generateArrayStructure(ContentProcessor<? extends Element, ? extends JsonNode> parentProcessor, List<ArrayExpression> arrayExpressions) {
        this.node = ((ObjectNode)parentProcessor.getNode()).putArray(((ArrayElement)this.element).showName());
        for (ArrayExpression childArrayExpression : arrayExpressions) {
            super.single(childArrayExpression, arrayExpressions.size());
        }
    }
}

