/*
 * Decompiled with CFR 0.152.
 */
package com.github.developframework.jsonview.spring.mvc;

import com.github.developframework.jsonview.core.JsonviewFactory;
import com.github.developframework.jsonview.core.exception.JsonviewException;
import com.github.developframework.jsonview.spring.mvc.AbstractJsonviewReturnValueHandler;
import com.github.developframework.jsonview.spring.mvc.annotation.JsonviewNamespace;
import com.github.developframework.jsonview.spring.mvc.annotation.TemplateId;
import org.springframework.core.MethodParameter;
import org.springframework.core.annotation.AnnotationUtils;

public abstract class AnnotationJsonviewReturnValueHandler<T>
extends AbstractJsonviewReturnValueHandler<T> {
    public AnnotationJsonviewReturnValueHandler(JsonviewFactory jsonviewFactory) {
        super(jsonviewFactory);
    }

    @Override
    protected String namespace(T returnValue, MethodParameter methodParameter) {
        if (methodParameter.hasMethodAnnotation(JsonviewNamespace.class)) {
            return ((JsonviewNamespace)methodParameter.getMethodAnnotation(JsonviewNamespace.class)).value();
        }
        JsonviewNamespace annotation = (JsonviewNamespace)AnnotationUtils.findAnnotation((Class)methodParameter.getContainingClass(), JsonviewNamespace.class);
        if (annotation != null) {
            return annotation.value();
        }
        throw new JsonviewException("@JsonviewNamespace is not found in Class \"%s\" with Method \"%s\".", new Object[]{methodParameter.getContainingClass(), methodParameter.getMethod().getName()});
    }

    @Override
    protected String templateId(T returnValue, MethodParameter methodParameter) {
        if (methodParameter.hasMethodAnnotation(TemplateId.class)) {
            return ((TemplateId)methodParameter.getMethodAnnotation(TemplateId.class)).value();
        }
        throw new JsonviewException("@TemplateId is not found in Class \"%s\" with Method \"%s\".", new Object[]{methodParameter.getContainingClass(), methodParameter.getMethod().getName()});
    }
}

