/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.jaxrs;

import com.github.dockerjava.api.command.ListSecretsCmd;
import com.github.dockerjava.api.model.Secret;
import com.github.dockerjava.core.DockerClientConfig;
import com.github.dockerjava.core.util.FiltersEncoder;
import com.github.dockerjava.jaxrs.AbstrSyncDockerCmdExec;
import com.google.common.net.UrlEscapers;
import java.util.List;
import java.util.Map;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.GenericType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListSecretsCmdExec
extends AbstrSyncDockerCmdExec<ListSecretsCmd, List<Secret>>
implements ListSecretsCmd.Exec {
    private static final Logger LOGGER = LoggerFactory.getLogger(ListSecretsCmdExec.class);

    public ListSecretsCmdExec(WebTarget baseResource, DockerClientConfig dockerClientConfig) {
        super(baseResource, dockerClientConfig);
    }

    @Override
    protected List<Secret> execute(ListSecretsCmd command) {
        WebTarget webTarget = this.getBaseResource().path("/secrets");
        if (command.getFilters() != null && !command.getFilters().isEmpty()) {
            webTarget = webTarget.queryParam("filters", new Object[]{UrlEscapers.urlPathSegmentEscaper().escape(FiltersEncoder.jsonEncode((Map)command.getFilters()))});
        }
        LOGGER.trace("GET: {}", (Object)webTarget);
        List secrets = (List)webTarget.request().accept(new String[]{"application/json"}).get((GenericType)new GenericType<List<Secret>>(){});
        LOGGER.trace("Response: {}", (Object)secrets);
        return secrets;
    }
}

