/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.okhttp;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.dockerjava.core.AbstractDockerCmdExecFactory;
import com.github.dockerjava.core.DockerClientConfig;
import com.github.dockerjava.core.SSLConfig;
import com.github.dockerjava.okhttp.NamedPipeSocketFactory;
import com.github.dockerjava.okhttp.OkHttpWebTarget;
import com.github.dockerjava.okhttp.UnixSocketFactory;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.SetMultimap;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URI;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import javax.net.SocketFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.X509TrustManager;
import okhttp3.ConnectionPool;
import okhttp3.Dns;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;

public class OkHttpDockerCmdExecFactory
extends AbstractDockerCmdExecFactory {
    private static final String SOCKET_SUFFIX = ".socket";
    private ObjectMapper objectMapper;
    private OkHttpClient okHttpClient;
    private HttpUrl baseUrl;

    public void init(DockerClientConfig dockerClientConfig) {
        HttpUrl.Builder baseUrlBuilder;
        super.init(dockerClientConfig);
        OkHttpClient.Builder clientBuilder = new OkHttpClient.Builder().readTimeout(0L, TimeUnit.SECONDS).retryOnConnectionFailure(true);
        URI dockerHost = dockerClientConfig.getDockerHost();
        switch (dockerHost.getScheme()) {
            case "unix": 
            case "npipe": {
                String socketPath = dockerHost.getPath();
                if ("unix".equals(dockerHost.getScheme())) {
                    clientBuilder.socketFactory((SocketFactory)new UnixSocketFactory(socketPath));
                } else {
                    clientBuilder.socketFactory((SocketFactory)new NamedPipeSocketFactory(socketPath));
                }
                clientBuilder.connectionPool(new ConnectionPool(0, 1L, TimeUnit.SECONDS)).dns(hostname -> {
                    if (hostname.endsWith(SOCKET_SUFFIX)) {
                        return Collections.singletonList(InetAddress.getByAddress(hostname, new byte[]{0, 0, 0, 0}));
                    }
                    return Dns.SYSTEM.lookup(hostname);
                });
            }
        }
        SSLConfig sslConfig = dockerClientConfig.getSSLConfig();
        boolean isSSL = false;
        if (sslConfig != null) {
            try {
                SSLContext sslContext = sslConfig.getSSLContext();
                if (sslContext != null) {
                    isSSL = true;
                    clientBuilder.sslSocketFactory(sslContext.getSocketFactory(), (X509TrustManager)new TrustAllX509TrustManager());
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        this.okHttpClient = clientBuilder.build();
        switch (dockerHost.getScheme()) {
            case "unix": 
            case "npipe": {
                baseUrlBuilder = new HttpUrl.Builder().scheme("http").host("docker.socket");
                break;
            }
            case "tcp": {
                baseUrlBuilder = new HttpUrl.Builder().scheme(isSSL ? "https" : "http").host(dockerHost.getHost()).port(dockerHost.getPort());
                break;
            }
            default: {
                baseUrlBuilder = HttpUrl.get((String)dockerHost.toString()).newBuilder();
            }
        }
        this.baseUrl = baseUrlBuilder.build();
        this.objectMapper = dockerClientConfig.getObjectMapper();
    }

    protected OkHttpWebTarget getBaseResource() {
        return new OkHttpWebTarget(this.objectMapper, this.okHttpClient, this.baseUrl, (ImmutableList<String>)ImmutableList.of(), (SetMultimap<String, String>)MultimapBuilder.hashKeys().hashSetValues().build());
    }

    public void close() throws IOException {
    }

    private static class TrustAllX509TrustManager
    implements X509TrustManager {
        private TrustAllX509TrustManager() {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] x509Certificates, String s) {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] x509Certificates, String s) {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }
    }
}

