/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.okhttp;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.exception.BadRequestException;
import com.github.dockerjava.api.exception.ConflictException;
import com.github.dockerjava.api.exception.DockerException;
import com.github.dockerjava.api.exception.InternalServerErrorException;
import com.github.dockerjava.api.exception.NotAcceptableException;
import com.github.dockerjava.api.exception.NotFoundException;
import com.github.dockerjava.api.exception.NotModifiedException;
import com.github.dockerjava.api.exception.UnauthorizedException;
import com.github.dockerjava.api.model.Frame;
import com.github.dockerjava.core.InvocationBuilder;
import com.github.dockerjava.core.MediaType;
import com.github.dockerjava.okhttp.FramedSink;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.Objects;
import java.util.function.Consumer;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.internal.connection.RealConnection;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.Okio;
import okio.Source;

class OkHttpInvocationBuilder
implements InvocationBuilder {
    static final ThreadLocal<Boolean> CLOSING = ThreadLocal.withInitial(() -> false);
    private final ObjectMapper objectMapper;
    private final OkHttpClient okHttpClient;
    private final Request.Builder requestBuilder;

    OkHttpInvocationBuilder(ObjectMapper objectMapper, OkHttpClient okHttpClient, HttpUrl httpUrl) {
        this.objectMapper = objectMapper;
        this.okHttpClient = okHttpClient;
        this.requestBuilder = new Request.Builder().url(httpUrl);
    }

    public OkHttpInvocationBuilder accept(MediaType mediaType) {
        return this.header("accept", mediaType.getMediaType());
    }

    public OkHttpInvocationBuilder header(String name, String value) {
        this.requestBuilder.header(name, value);
        return this;
    }

    public void delete() {
        Request request = this.requestBuilder.delete().build();
        this.execute(request).close();
    }

    public void get(ResultCallback<Frame> resultCallback) {
        Request request = this.requestBuilder.get().build();
        this.executeAndStream(request, resultCallback, new FramedSink(resultCallback));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> T get(TypeReference<T> typeReference) {
        try (InputStream inputStream = this.get();){
            Object object = this.objectMapper.readValue(inputStream, typeReference);
            return (T)object;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public <T> void get(TypeReference<T> typeReference, ResultCallback<T> resultCallback) {
        Request request = this.requestBuilder.get().build();
        this.executeAndStream(request, resultCallback, new JsonSink<T>(this.objectMapper, typeReference, resultCallback));
    }

    public InputStream post(Object entity) {
        try {
            Request request = this.requestBuilder.post(RequestBody.create((okhttp3.MediaType)okhttp3.MediaType.parse((String)"application/json"), (byte[])this.objectMapper.writeValueAsBytes(entity))).build();
            return this.execute(request).body().byteStream();
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> T post(Object entity, TypeReference<T> typeReference) {
        try {
            Request request = this.requestBuilder.post(RequestBody.create((okhttp3.MediaType)okhttp3.MediaType.parse((String)"application/json"), (byte[])this.objectMapper.writeValueAsBytes(entity))).build();
            try (Response response = this.execute(request);){
                String inputStream = response.body().string();
                Object object = this.objectMapper.readValue(inputStream, typeReference);
                return (T)object;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public <T> void post(Object entity, TypeReference<T> typeReference, ResultCallback<T> resultCallback) {
        try {
            this.post(typeReference, resultCallback, new ByteArrayInputStream(this.objectMapper.writeValueAsBytes(entity)));
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> T post(TypeReference<T> typeReference, InputStream body) {
        try (InputStream inputStream = this.post(body);){
            Object object = this.objectMapper.readValue(inputStream, typeReference);
            return (T)object;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void post(Object entity, InputStream stdin, ResultCallback<Frame> resultCallback) {
        Request request;
        try {
            request = this.requestBuilder.post(RequestBody.create((okhttp3.MediaType)okhttp3.MediaType.parse((String)"application/json"), (byte[])this.objectMapper.writeValueAsBytes(entity))).build();
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
        OkHttpClient clientToUse = this.okHttpClient;
        if (stdin != null) {
            clientToUse = clientToUse.newBuilder().addNetworkInterceptor(chain -> {
                Response response = chain.proceed(chain.request());
                if (response.isSuccessful()) {
                    Thread thread = new Thread(() -> {
                        try {
                            Field sinkField = RealConnection.class.getDeclaredField("sink");
                            sinkField.setAccessible(true);
                            try (BufferedSink sink = (BufferedSink)sinkField.get(chain.connection());
                                 Source source = Okio.source((InputStream)stdin);){
                                while (sink.isOpen()) {
                                    int available = stdin.available();
                                    if (available <= 0) continue;
                                    sink.write(source, (long)available);
                                    sink.emit();
                                }
                            }
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                    });
                    thread.start();
                }
                return response;
            }).build();
        }
        this.executeAndStream(clientToUse, request, resultCallback, new FramedSink(resultCallback));
    }

    public <T> void post(TypeReference<T> typeReference, ResultCallback<T> resultCallback, InputStream body) {
        Request request = this.requestBuilder.post(this.toRequestBody(body, null)).build();
        this.executeAndStream(request, resultCallback, new JsonSink<T>(this.objectMapper, typeReference, resultCallback));
    }

    public void postStream(InputStream body) {
        Request request = this.requestBuilder.post(this.toRequestBody(body, null)).build();
        this.execute(request).close();
    }

    public InputStream get() {
        Request request = this.requestBuilder.get().build();
        return this.execute(request).body().byteStream();
    }

    public void put(InputStream body, MediaType mediaType) {
        Request request = this.requestBuilder.put(this.toRequestBody(body, mediaType.toString())).build();
        this.execute(request).close();
    }

    protected RequestBody toRequestBody(final InputStream body, final String mediaType) {
        return new RequestBody(){

            public okhttp3.MediaType contentType() {
                if (mediaType == null) {
                    return null;
                }
                return okhttp3.MediaType.parse((String)mediaType);
            }

            public void writeTo(BufferedSink sink) throws IOException {
                try (Source source = Okio.source((InputStream)body);){
                    sink.writeAll(source);
                }
            }
        };
    }

    protected Response execute(Request request) {
        return this.execute(this.okHttpClient, request);
    }

    protected Response execute(OkHttpClient okHttpClient, Request request) {
        try {
            Response response = okHttpClient.newCall(request).execute();
            if (!response.isSuccessful()) {
                String body = response.body().string();
                switch (response.code()) {
                    case 304: {
                        throw new NotModifiedException(body);
                    }
                    case 400: {
                        throw new BadRequestException(body);
                    }
                    case 401: {
                        throw new UnauthorizedException(body);
                    }
                    case 404: {
                        throw new NotFoundException(body);
                    }
                    case 406: {
                        throw new NotAcceptableException(body);
                    }
                    case 409: {
                        throw new ConflictException(body);
                    }
                    case 500: {
                        throw new InternalServerErrorException(body);
                    }
                }
                throw new DockerException(body, response.code());
            }
            return response;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected <T> void executeAndStream(Request request, ResultCallback<T> callback, Consumer<BufferedSource> sourceConsumer) {
        this.executeAndStream(this.okHttpClient, request, callback, sourceConsumer);
    }

    protected <T> void executeAndStream(OkHttpClient okHttpClient, Request request, ResultCallback<T> callback, Consumer<BufferedSource> sourceConsumer) {
        Thread thread = new Thread(() -> {
            try (Response response = this.execute(okHttpClient, request.newBuilder().tag((Object)"streaming").build());
                 BufferedSource source = response.body().source();){
                callback.onStart(() -> {
                    boolean previous = CLOSING.get();
                    CLOSING.set(true);
                    try {
                        response.close();
                    }
                    finally {
                        CLOSING.set(previous);
                    }
                });
                sourceConsumer.accept(source);
                callback.onComplete();
            }
            catch (Exception e) {
                callback.onError((Throwable)e);
            }
        }, "tc-okhttp-stream-" + Objects.hashCode(request));
        thread.setDaemon(true);
        thread.start();
    }

    private static class JsonSink<T>
    implements Consumer<BufferedSource> {
        private final ObjectMapper objectMapper;
        private final TypeReference<T> typeReference;
        private final ResultCallback<T> resultCallback;

        JsonSink(ObjectMapper objectMapper, TypeReference<T> typeReference, ResultCallback<T> resultCallback) {
            this.objectMapper = objectMapper;
            this.typeReference = typeReference;
            this.resultCallback = resultCallback;
        }

        @Override
        public void accept(BufferedSource source) {
            try {
                String line;
                while ((line = source.readUtf8Line()) != null) {
                    this.resultCallback.onNext(this.objectMapper.readValue(line, this.typeReference));
                }
            }
            catch (Exception e) {
                this.resultCallback.onError((Throwable)e);
            }
        }
    }
}

