/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.okhttp;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.dockerjava.core.InvocationBuilder;
import com.github.dockerjava.core.WebTarget;
import com.github.dockerjava.okhttp.OkHttpInvocationBuilder;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.SetMultimap;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import org.apache.commons.lang.StringUtils;

class OkHttpWebTarget
implements WebTarget {
    final ObjectMapper objectMapper;
    final OkHttpClient okHttpClient;
    final HttpUrl baseUrl;
    final ImmutableList<String> path;
    final SetMultimap<String, String> queryParams;

    OkHttpWebTarget(ObjectMapper objectMapper, OkHttpClient okHttpClient, HttpUrl baseUrl, ImmutableList<String> path, SetMultimap<String, String> queryParams) {
        this.objectMapper = objectMapper;
        this.okHttpClient = okHttpClient;
        this.baseUrl = baseUrl;
        this.path = path;
        this.queryParams = queryParams;
    }

    public InvocationBuilder request() {
        String resource = StringUtils.join(this.path, (String)"/");
        if (!resource.startsWith("/")) {
            resource = "/" + resource;
        }
        HttpUrl.Builder baseUrlBuilder = this.baseUrl.newBuilder().encodedPath(resource);
        for (Map.Entry queryParamEntry : this.queryParams.asMap().entrySet()) {
            String key = (String)queryParamEntry.getKey();
            for (String paramValue : (Collection)queryParamEntry.getValue()) {
                baseUrlBuilder.addQueryParameter(key, paramValue);
            }
        }
        return new OkHttpInvocationBuilder(this.objectMapper, this.okHttpClient, baseUrlBuilder.build());
    }

    public OkHttpWebTarget path(String ... components) {
        ImmutableList newPath = ImmutableList.builder().addAll(this.path).add((Object[])components).build();
        return new OkHttpWebTarget(this.objectMapper, this.okHttpClient, this.baseUrl, (ImmutableList<String>)newPath, this.queryParams);
    }

    public OkHttpWebTarget resolveTemplate(String name, Object value) {
        ImmutableList.Builder newPath = ImmutableList.builder();
        for (String component : this.path) {
            component = component.replaceAll("\\{" + name + "\\}", value.toString());
            newPath.add((Object)component);
        }
        return new OkHttpWebTarget(this.objectMapper, this.okHttpClient, this.baseUrl, (ImmutableList<String>)newPath.build(), this.queryParams);
    }

    public OkHttpWebTarget queryParam(String name, Object value) {
        if (value == null) {
            return this;
        }
        HashMultimap newQueryParams = HashMultimap.create(this.queryParams);
        newQueryParams.put((Object)name, (Object)value.toString());
        return new OkHttpWebTarget(this.objectMapper, this.okHttpClient, this.baseUrl, this.path, (SetMultimap<String, String>)newQueryParams);
    }

    public OkHttpWebTarget queryParamsSet(String name, Set<?> values) {
        HashMultimap newQueryParams = HashMultimap.create(this.queryParams);
        newQueryParams.replaceValues((Object)name, (Iterable)values.stream().filter(Objects::nonNull).map(Object::toString).collect(Collectors.toSet()));
        return new OkHttpWebTarget(this.objectMapper, this.okHttpClient, this.baseUrl, this.path, (SetMultimap<String, String>)newQueryParams);
    }

    public OkHttpWebTarget queryParamsJsonMap(String name, Map<String, String> values) {
        if (values == null || values.isEmpty()) {
            return this;
        }
        try {
            return this.queryParam(name, this.objectMapper.writeValueAsString(values));
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }
}

