package com.github.dockerjava.transport;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link DockerHttpClient.Request}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code new DockerHttpClient.Request.Builder()}.
 */
@Generated(from = "DockerHttpClient.Request", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
final class ImmutableRequest extends DockerHttpClient.Request {
  private final String method;
  private final String path;
  private final @Nullable InputStream body;
  private final @Nullable byte[] bodyBytes;
  private final @Nullable InputStream hijackedInput;
  private final Map<String, String> headers;

  private ImmutableRequest(ImmutableRequest.Builder builder) {
    this.method = builder.method;
    this.path = builder.path;
    this.bodyBytes = builder.bodyBytes;
    this.hijackedInput = builder.hijackedInput;
    this.headers = createUnmodifiableMap(false, false, builder.headers);
    this.body = builder.bodyIsSet()
        ? builder.body
        : super.body();
  }

  private ImmutableRequest(
      String method,
      String path,
      @Nullable InputStream body,
      @Nullable byte[] bodyBytes,
      @Nullable InputStream hijackedInput,
      Map<String, String> headers) {
    this.method = method;
    this.path = path;
    this.body = body;
    this.bodyBytes = bodyBytes;
    this.hijackedInput = hijackedInput;
    this.headers = headers;
  }

  /**
   * @return The value of the {@code method} attribute
   */
  @Override
  public String method() {
    return method;
  }

  /**
   * @return The value of the {@code path} attribute
   */
  @Override
  public String path() {
    return path;
  }

  /**
   * @return The value of the {@code body} attribute
   */
  @Override
  public @Nullable InputStream body() {
    return body;
  }

  /**
   * @return A cloned {@code bodyBytes} array
   */
  @Override
  public @Nullable byte[] bodyBytes() {
    return bodyBytes;
  }

  /**
   * @return The value of the {@code hijackedInput} attribute
   */
  @Override
  public @Nullable InputStream hijackedInput() {
    return hijackedInput;
  }

  /**
   * @return The value of the {@code headers} attribute
   */
  @Override
  public Map<String, String> headers() {
    return headers;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DockerHttpClient.Request#method() method} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for method
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRequest withMethod(String value) {
    String newValue = Objects.requireNonNull(value, "method");
    if (this.method.equals(newValue)) return this;
    return new ImmutableRequest(newValue, this.path, this.body, this.bodyBytes, this.hijackedInput, this.headers);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DockerHttpClient.Request#path() path} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for path
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRequest withPath(String value) {
    String newValue = Objects.requireNonNull(value, "path");
    if (this.path.equals(newValue)) return this;
    return new ImmutableRequest(this.method, newValue, this.body, this.bodyBytes, this.hijackedInput, this.headers);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DockerHttpClient.Request#body() body} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for body (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRequest withBody(@Nullable InputStream value) {
    if (this.body == value) return this;
    return new ImmutableRequest(this.method, this.path, value, this.bodyBytes, this.hijackedInput, this.headers);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link DockerHttpClient.Request#bodyBytes() bodyBytes}.
   * The array is cloned before being saved as attribute values.
   * @param elements The non-null elements for bodyBytes
   * @return A modified copy of {@code this} object
   */
  public final ImmutableRequest withBodyBytes(@Nullable byte... elements) {
    @Nullable byte[] newValue = elements == null ? null : elements.clone();
    return new ImmutableRequest(this.method, this.path, this.body, newValue, this.hijackedInput, this.headers);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DockerHttpClient.Request#hijackedInput() hijackedInput} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for hijackedInput (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRequest withHijackedInput(@Nullable InputStream value) {
    if (this.hijackedInput == value) return this;
    return new ImmutableRequest(this.method, this.path, this.body, this.bodyBytes, value, this.headers);
  }

  /**
   * Copy the current immutable object by replacing the {@link DockerHttpClient.Request#headers() headers} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the headers map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableRequest withHeaders(Map<String, ? extends String> entries) {
    if (this.headers == entries) return this;
    Map<String, String> newValue = createUnmodifiableMap(true, false, entries);
    return new ImmutableRequest(this.method, this.path, this.body, this.bodyBytes, this.hijackedInput, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableRequest
        && equalTo(0, (ImmutableRequest) another);
  }

  private boolean equalTo(int synthetic, ImmutableRequest another) {
    return method.equals(another.method)
        && path.equals(another.path)
        && Objects.equals(body, another.body)
        && Arrays.equals(bodyBytes, another.bodyBytes)
        && Objects.equals(hijackedInput, another.hijackedInput)
        && headers.equals(another.headers);
  }

  /**
   * Computes a hash code from attributes: {@code method}, {@code path}, {@code body}, {@code bodyBytes}, {@code hijackedInput}, {@code headers}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + method.hashCode();
    h += (h << 5) + path.hashCode();
    h += (h << 5) + Objects.hashCode(body);
    h += (h << 5) + Arrays.hashCode(bodyBytes);
    h += (h << 5) + Objects.hashCode(hijackedInput);
    h += (h << 5) + headers.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Request} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Request{"
        + "method=" + method
        + ", path=" + path
        + ", body=" + body
        + ", bodyBytes=" + Arrays.toString(bodyBytes)
        + ", hijackedInput=" + hijackedInput
        + ", headers=" + headers
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link DockerHttpClient.Request} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Request instance
   */
  public static DockerHttpClient.Request copyOf(DockerHttpClient.Request instance) {
    if (instance instanceof ImmutableRequest) {
      return (ImmutableRequest) instance;
    }
    return new DockerHttpClient.Request.Builder()
        .from(instance)
        .build();
  }

  /**
   * Builds instances of type {@link DockerHttpClient.Request Request}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "DockerHttpClient.Request", generator = "Immutables")
  @NotThreadSafe
  public static class Builder {
    private static final long INIT_BIT_METHOD = 0x1L;
    private static final long INIT_BIT_PATH = 0x2L;
    private static final long OPT_BIT_BODY = 0x1L;
    private long initBits = 0x3L;
    private long optBits;

    private @Nullable String method;
    private @Nullable String path;
    private @Nullable InputStream body;
    private @Nullable byte[] bodyBytes;
    private @Nullable InputStream hijackedInput;
    private Map<String, String> headers = new LinkedHashMap<String, String>();

    /**
     * Creates a builder for {@link DockerHttpClient.Request Request} instances.
     * <pre>
     * new DockerHttpClient.Request.Builder()
     *    .method(String) // required {@link DockerHttpClient.Request#method() method}
     *    .path(String) // required {@link DockerHttpClient.Request#path() path}
     *    .body(java.io.InputStream | null) // nullable {@link DockerHttpClient.Request#body() body}
     *    .bodyBytes(byte[] | null) // nullable {@link DockerHttpClient.Request#bodyBytes() bodyBytes}
     *    .hijackedInput(java.io.InputStream | null) // nullable {@link DockerHttpClient.Request#hijackedInput() hijackedInput}
     *    .putHeader|putAllHeaders(String =&gt; String) // {@link DockerHttpClient.Request#headers() headers} mappings
     *    .build();
     * </pre>
     */
    public Builder() {
      if (!(this instanceof DockerHttpClient.Request.Builder)) {
        throw new UnsupportedOperationException("Use: new DockerHttpClient.Request.Builder()");
      }
    }

    /**
     * Fill a builder with attribute values from the provided {@code Request} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final DockerHttpClient.Request.Builder from(DockerHttpClient.Request instance) {
      Objects.requireNonNull(instance, "instance");
      this.method(instance.method());
      this.path(instance.path());
      @Nullable InputStream bodyValue = instance.body();
      if (bodyValue != null) {
        body(bodyValue);
      }
      @Nullable byte[] bodyBytesValue = instance.bodyBytes();
      if (bodyBytesValue != null) {
        bodyBytes(bodyBytesValue);
      }
      @Nullable InputStream hijackedInputValue = instance.hijackedInput();
      if (hijackedInputValue != null) {
        hijackedInput(hijackedInputValue);
      }
      putAllHeaders(instance.headers());
      return (DockerHttpClient.Request.Builder) this;
    }

    /**
     * Initializes the value for the {@link DockerHttpClient.Request#method() method} attribute.
     * @param method The value for method 
     * @return {@code this} builder for use in a chained invocation
     */
    public final DockerHttpClient.Request.Builder method(String method) {
      this.method = Objects.requireNonNull(method, "method");
      initBits &= ~INIT_BIT_METHOD;
      return (DockerHttpClient.Request.Builder) this;
    }

    /**
     * Initializes the value for the {@link DockerHttpClient.Request#path() path} attribute.
     * @param path The value for path 
     * @return {@code this} builder for use in a chained invocation
     */
    public final DockerHttpClient.Request.Builder path(String path) {
      this.path = Objects.requireNonNull(path, "path");
      initBits &= ~INIT_BIT_PATH;
      return (DockerHttpClient.Request.Builder) this;
    }

    /**
     * Initializes the value for the {@link DockerHttpClient.Request#body() body} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link DockerHttpClient.Request#body() body}.</em>
     * @param body The value for body (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final DockerHttpClient.Request.Builder body(@Nullable InputStream body) {
      this.body = body;
      optBits |= OPT_BIT_BODY;
      return (DockerHttpClient.Request.Builder) this;
    }

    /**
     * Initializes the value for the {@link DockerHttpClient.Request#bodyBytes() bodyBytes} attribute.
     * @param bodyBytes The elements for bodyBytes
     * @return {@code this} builder for use in a chained invocation
     */
    public final DockerHttpClient.Request.Builder bodyBytes(byte... bodyBytes) {
      this.bodyBytes = bodyBytes;
      return (DockerHttpClient.Request.Builder) this;
    }

    /**
     * Initializes the value for the {@link DockerHttpClient.Request#hijackedInput() hijackedInput} attribute.
     * @param hijackedInput The value for hijackedInput (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final DockerHttpClient.Request.Builder hijackedInput(@Nullable InputStream hijackedInput) {
      this.hijackedInput = hijackedInput;
      return (DockerHttpClient.Request.Builder) this;
    }

    /**
     * Put one entry to the {@link DockerHttpClient.Request#headers() headers} map.
     * @param key The key in the headers map
     * @param value The associated value in the headers map
     * @return {@code this} builder for use in a chained invocation
     */
    public final DockerHttpClient.Request.Builder putHeader(String key, String value) {
      this.headers.put(
          Objects.requireNonNull(key, "headers key"),
          Objects.requireNonNull(value, value == null ? "headers value for key: " + key : null));
      return (DockerHttpClient.Request.Builder) this;
    }

    /**
     * Put one entry to the {@link DockerHttpClient.Request#headers() headers} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final DockerHttpClient.Request.Builder putHeader(Map.Entry<String, ? extends String> entry) {
      String k = entry.getKey();
      String v = entry.getValue();
      this.headers.put(
          Objects.requireNonNull(k, "headers key"),
          Objects.requireNonNull(v, v == null ? "headers value for key: " + k : null));
      return (DockerHttpClient.Request.Builder) this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link DockerHttpClient.Request#headers() headers} map. Nulls are not permitted
     * @param entries The entries that will be added to the headers map
     * @return {@code this} builder for use in a chained invocation
     */
    public final DockerHttpClient.Request.Builder headers(Map<String, ? extends String> entries) {
      this.headers.clear();
      return putAllHeaders(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link DockerHttpClient.Request#headers() headers} map. Nulls are not permitted
     * @param entries The entries that will be added to the headers map
     * @return {@code this} builder for use in a chained invocation
     */
    public final DockerHttpClient.Request.Builder putAllHeaders(Map<String, ? extends String> entries) {
      for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
        String k = e.getKey();
        String v = e.getValue();
        this.headers.put(
            Objects.requireNonNull(k, "headers key"),
            Objects.requireNonNull(v, v == null ? "headers value for key: " + k : null));
      }
      return (DockerHttpClient.Request.Builder) this;
    }

    /**
     * Builds a new {@link DockerHttpClient.Request Request}.
     * @return An immutable instance of Request
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public DockerHttpClient.Request build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableRequest(this);
    }

    private boolean bodyIsSet() {
      return (optBits & OPT_BIT_BODY) != 0;
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_METHOD) != 0) attributes.add("method");
      if ((initBits & INIT_BIT_PATH) != 0) attributes.add("path");
      return "Cannot build Request, some of required attributes are not set " + attributes;
    }
  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        Objects.requireNonNull(v, v == null ? "value for key: " + k : null);
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<>(map.size() * 4 / 3 + 1);
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            Objects.requireNonNull(v, v == null ? "value for key: " + k : null);
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }
}
