/*
 * Decompiled with CFR 0.152.
 */
package com.github.drinkjava2.jsqlbox;

import com.github.drinkjava2.jdbpro.PreparedSQL;
import com.github.drinkjava2.jdbpro.SqlItem;
import com.github.drinkjava2.jdbpro.SqlOption;
import com.github.drinkjava2.jdialects.ClassCacheUtils;
import com.github.drinkjava2.jdialects.model.ColumnModel;
import com.github.drinkjava2.jdialects.model.TableModel;
import com.github.drinkjava2.jsqlbox.ActiveRecordSupport;
import com.github.drinkjava2.jsqlbox.SqlBox;
import com.github.drinkjava2.jsqlbox.SqlBoxContext;
import com.github.drinkjava2.jsqlbox.SqlBoxException;
import com.github.drinkjava2.jsqlbox.SqlBoxUtils;
import java.lang.reflect.Method;

public interface ActiveEntity
extends ActiveRecordSupport {
    default public SqlBox box() {
        SqlBox box = SqlBoxUtils.findBoxOfPOJO((Object)this);
        if (box == null) {
            box = SqlBoxUtils.createSqlBox((SqlBoxContext)SqlBoxContext.gctx(), this.getClass());
            SqlBoxUtils.bindBoxToPOJO((Object)this, (SqlBox)box);
        }
        return box;
    }

    default public SqlBox bindedBox() {
        return SqlBoxUtils.findBoxOfPOJO((Object)this);
    }

    default public void bindBox(SqlBox box) {
        SqlBoxUtils.bindBoxToPOJO((Object)this, (SqlBox)box);
    }

    default public void unbindBox() {
        SqlBoxUtils.unbindBoxOfPOJO((Object)this);
    }

    default public TableModel tableModel() {
        return this.box().getTableModel();
    }

    default public ColumnModel columnModel(String columnName) {
        return this.box().getTableModel().getColumn(columnName);
    }

    default public String table() {
        return this.box().getTableModel().getTableName();
    }

    default public ActiveRecordSupport alias(String alias) {
        this.box().getTableModel().setAlias(alias);
        return this;
    }

    default public SqlBoxContext ctx() {
        SqlBox theBox = this.box();
        if (theBox.getContext() == null) {
            theBox.setContext(SqlBoxContext.getGlobalSqlBoxContext());
        }
        return theBox.getContext();
    }

    default public ActiveRecordSupport useContext(SqlBoxContext ctx) {
        this.box().setContext(ctx);
        return this;
    }

    default public <T> T insert(Object ... optionalSqlItems) {
        SqlBoxContext ctx = this.ctx();
        if (ctx == null) {
            throw new SqlBoxException("No default global SqlBoxContext found, need use method SqlBoxContext.setGlobalSqlBoxContext() to set a global default SqlBoxContext instance at the beginning of appication.");
        }
        ctx.insert((Object)this, optionalSqlItems);
        return (T)this;
    }

    default public <T> T update(Object ... optionalSqlItems) {
        SqlBoxContext ctx = this.ctx();
        if (ctx == null) {
            throw new SqlBoxException("No default global SqlBoxContext found, need use method SqlBoxContext.setGlobalSqlBoxContext() to set a global default SqlBoxContext instance at the beginning of appication.");
        }
        ctx.update((Object)this, optionalSqlItems);
        return (T)this;
    }

    default public void delete(Object ... optionalSqlItems) {
        SqlBoxContext ctx = this.ctx();
        if (ctx == null) {
            throw new SqlBoxException("No default global SqlBoxContext found, need use method SqlBoxContext.setGlobalSqlBoxContext() to set a global default SqlBoxContext instance at the beginning of appication.");
        }
        ctx.delete((Object)this, optionalSqlItems);
    }

    default public <T> T load(Object ... optionalSqlItems) {
        SqlBoxContext ctx = this.ctx();
        if (ctx == null) {
            throw new SqlBoxException("No default global SqlBoxContext found, need use method SqlBoxContext.setGlobalSqlBoxContext() to set a global default SqlBoxContext instance at the beginning of appication.");
        }
        return (T)ctx.load((Object)this, optionalSqlItems);
    }

    default public <T> T loadById(Object idOrIdMap, Object ... optionalSqlItems) {
        SqlBoxContext ctx = this.ctx();
        if (ctx == null) {
            throw new SqlBoxException("No default global SqlBoxContext found, need use method SqlBoxContext.setGlobalSqlBoxContext() to set a global default SqlBoxContext instance at the beginning of appication.");
        }
        return (T)ctx.loadById(this.getClass(), idOrIdMap, optionalSqlItems);
    }

    default public <T> T loadByQuery(Object ... sqlItems) {
        SqlBoxContext ctx = this.ctx();
        if (ctx == null) {
            throw new SqlBoxException("No default global SqlBoxContext found, need use method SqlBoxContext.setGlobalSqlBoxContext() to set a global default SqlBoxContext instance at the beginning of appication.");
        }
        return (T)ctx.loadByQuery(this.getClass(), sqlItems);
    }

    default public ActiveRecordSupport put(Object ... fieldAndValues) {
        for (int i = 0; i < fieldAndValues.length / 2; ++i) {
            String field = (String)fieldAndValues[i * 2];
            Object value = fieldAndValues[i * 2 + 1];
            Method writeMethod = ClassCacheUtils.getClassFieldWriteMethod(this.getClass(), (String)field);
            try {
                writeMethod.invoke((Object)this, value);
                continue;
            }
            catch (Exception e) {
                throw new SqlBoxException((Throwable)e);
            }
        }
        return this;
    }

    default public ActiveRecordSupport putFields(String ... fieldNames) {
        lastTimePutFieldsCache.set(fieldNames);
        return this;
    }

    default public ActiveRecordSupport putValues(Object ... values) {
        String[] fields = (String[])lastTimePutFieldsCache.get();
        if (values.length == 0 || fields == null || fields.length == 0) {
            throw new SqlBoxException("putValues fields or values can not be empty");
        }
        if (values.length != fields.length) {
            throw new SqlBoxException("putValues fields and values number not match");
        }
        for (int i = 0; i < fields.length; ++i) {
            Method writeMethod = ClassCacheUtils.getClassFieldWriteMethod(this.getClass(), (String)fields[i]);
            if (writeMethod == null) {
                throw new SqlBoxException("Not found writeMethod for '" + this.getClass() + "' class's method '" + fields[i] + "'");
            }
            try {
                writeMethod.invoke((Object)this, values[i]);
                continue;
            }
            catch (Exception e) {
                throw new SqlBoxException((Throwable)e);
            }
        }
        return this;
    }

    default public <T> T guess(Object ... params) {
        return (T)this.ctx().getSqlMapperGuesser().guess(this.ctx(), (Object)this, params);
    }

    default public String guessSQL() {
        return this.ctx().getSqlMapperGuesser().guessSQL(this.ctx(), (Object)this);
    }

    default public PreparedSQL guessPreparedSQL(Object ... params) {
        return this.ctx().getSqlMapperGuesser().doGuessPreparedSQL(this.ctx(), (Object)this, params);
    }

    default public SqlItem bind(Object ... parameters) {
        return new SqlItem(SqlOption.BIND, parameters);
    }
}

