/*
 * Decompiled with CFR 0.152.
 */
package com.github.drinkjava2.jsqlbox;

import com.github.drinkjava2.jdbpro.PreparedSQL;
import com.github.drinkjava2.jdbpro.SqlItem;
import com.github.drinkjava2.jdbpro.SqlOption;
import com.github.drinkjava2.jdialects.ArrayUtils;
import com.github.drinkjava2.jdialects.ClassCacheUtils;
import com.github.drinkjava2.jdialects.TableModelUtils;
import com.github.drinkjava2.jdialects.model.ColumnModel;
import com.github.drinkjava2.jdialects.model.TableModel;
import com.github.drinkjava2.jsqlbox.ActiveRecordSupport;
import com.github.drinkjava2.jsqlbox.SqlBoxContext;
import com.github.drinkjava2.jsqlbox.SqlBoxContextUtils;
import com.github.drinkjava2.jsqlbox.SqlBoxException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.Set;

public interface ActiveEntity<T>
extends ActiveRecordSupport<T> {
    default public SqlBoxContext ctx(Object ... optionItems) {
        for (Object item : optionItems) {
            if (item == null || !(item instanceof SqlBoxContext)) continue;
            return (SqlBoxContext)item;
        }
        return SqlBoxContext.getGlobalSqlBoxContext();
    }

    default public T insert(Object ... optionItems) {
        return (T)this.ctx(optionItems).entityInsert((Object)this, optionItems);
    }

    default public T update(Object ... optionItems) {
        return (T)this.ctx(optionItems).entityUpdate((Object)this, optionItems);
    }

    default public int updateTry(Object ... optionItems) {
        return this.ctx(optionItems).entityUpdateTry((Object)this, optionItems);
    }

    default public void delete(Object ... optionItems) {
        this.ctx(optionItems).entityDelete((Object)this, optionItems);
    }

    default public int deleteTry(Object ... optionItems) {
        return this.ctx(optionItems).entityDeleteTry((Object)this, optionItems);
    }

    default public void deleteById(Object id, Object ... optionItems) {
        this.ctx(optionItems).entityDeleteById(this.getClass(), id, optionItems);
    }

    default public int deleteByIdTry(Object id, Object ... optionItems) {
        return this.ctx(optionItems).entityDeleteByIdTry(this.getClass(), id, optionItems);
    }

    default public boolean exist(Object ... optionItems) {
        return this.ctx(optionItems).entityExist((Object)this, optionItems);
    }

    default public boolean existById(Object id, Object ... optionItems) {
        return this.ctx(optionItems).entityExistById(this.getClass(), id, optionItems);
    }

    default public T load(Object ... optionItems) {
        return (T)this.ctx(optionItems).entityLoad((Object)this, optionItems);
    }

    default public int loadTry(Object ... optionItems) {
        return this.ctx(optionItems).entityLoadTry((Object)this, optionItems);
    }

    default public T loadById(Object id, Object ... optionItems) {
        return (T)this.ctx(optionItems).entityLoadById(this.getClass(), id, optionItems);
    }

    default public T loadByIdTry(Object id, Object ... optionItems) {
        return (T)this.ctx(optionItems).entityLoadByIdTry(this.getClass(), id, optionItems);
    }

    default public List<T> findAll(Object ... optionItems) {
        return this.ctx(optionItems).entityFindAll(this.getClass(), optionItems);
    }

    default public List<T> findByIds(Iterable<?> ids, Object ... optionItems) {
        return this.ctx(optionItems).entityFindByIds(this.getClass(), ids, optionItems);
    }

    default public List<T> findBySQL(Object ... optionItems) {
        return this.ctx(optionItems).iQueryForEntityList(new Object[]{this.getClass(), optionItems});
    }

    default public List<T> findBySample(Object sampleBean, Object ... optionItems) {
        return this.ctx(optionItems).entityFindBySample(sampleBean, optionItems);
    }

    public static Object[] insertThisClassIfNotHave(Object entity, Object ... optionItems) {
        Object[] items = optionItems;
        TableModel[] models = SqlBoxContextUtils.findAllModels((Object[])optionItems);
        if (models.length == 0) {
            throw new SqlBoxException("No TableMode found for entity.");
        }
        TableModel model = models[0];
        if (!entity.getClass().equals(model.getEntityClass())) {
            model = TableModelUtils.entity2ReadOnlyModel(entity.getClass());
            items = ArrayUtils.insertArray((Object)model, (Object[])items);
        }
        return items;
    }

    default public <E> E findOneRelated(Object ... optionItems) {
        Object[] items = ActiveEntity.insertThisClassIfNotHave(this, optionItems);
        return (E)this.ctx(optionItems).entityFindRelatedOne((Object)this, items);
    }

    default public <E> List<E> findRelatedList(Object ... optionItems) {
        Object[] items = ActiveEntity.insertThisClassIfNotHave(this, optionItems);
        return this.ctx(optionItems).entityFindRelatedList((Object)this, items);
    }

    default public <E> Set<E> findRelatedSet(Object ... optionItems) {
        Object[] items = ActiveEntity.insertThisClassIfNotHave(this, optionItems);
        return this.ctx(optionItems).entityFindRelatedSet((Object)this, items);
    }

    default public <E> Map<Object, E> findRelatedMap(Object ... optionItems) {
        Object[] items = ActiveEntity.insertThisClassIfNotHave(this, optionItems);
        return this.ctx(optionItems).entityFindRelatedMap((Object)this, items);
    }

    default public int countAll(Object ... optionItems) {
        return this.ctx(optionItems).entityCountAll(this.getClass(), optionItems);
    }

    default public T put(Object ... fieldAndValues) {
        for (int i = 0; i < fieldAndValues.length / 2; ++i) {
            String field = (String)fieldAndValues[i * 2];
            Object value = fieldAndValues[i * 2 + 1];
            Method writeMethod = ClassCacheUtils.getClassFieldWriteMethod(this.getClass(), (String)field);
            try {
                writeMethod.invoke((Object)this, value);
                continue;
            }
            catch (Exception e) {
                throw new SqlBoxException((Throwable)e);
            }
        }
        return (T)this;
    }

    default public T putFields(String ... fieldNames) {
        lastTimePutFieldsCache.set(fieldNames);
        return (T)this;
    }

    default public T putValues(Object ... values) {
        String[] fields = (String[])lastTimePutFieldsCache.get();
        if (values.length == 0 || fields == null || fields.length == 0) {
            throw new SqlBoxException("putValues fields or values can not be empty");
        }
        if (values.length != fields.length) {
            throw new SqlBoxException("putValues fields and values number not match");
        }
        for (int i = 0; i < fields.length; ++i) {
            Method writeMethod = ClassCacheUtils.getClassFieldWriteMethod(this.getClass(), (String)fields[i]);
            if (writeMethod == null) {
                throw new SqlBoxException("Not found writeMethod for '" + this.getClass() + "' class's method '" + fields[i] + "'");
            }
            try {
                writeMethod.invoke((Object)this, values[i]);
                continue;
            }
            catch (Exception e) {
                throw new SqlBoxException((Throwable)e);
            }
        }
        return (T)this;
    }

    default public <U> U guess(Object ... params) {
        return (U)this.ctx(new Object[0]).getSqlMapperGuesser().guess(this.ctx(new Object[0]), (Object)this, params);
    }

    default public String guessSQL() {
        return this.ctx(new Object[0]).getSqlMapperGuesser().guessSQL(this.ctx(new Object[0]), (Object)this);
    }

    default public PreparedSQL guessPreparedSQL(Object ... params) {
        return this.ctx(new Object[0]).getSqlMapperGuesser().doGuessPreparedSQL(this.ctx(new Object[0]), (Object)this, params);
    }

    default public SqlItem bind(Object ... parameters) {
        return new SqlItem(SqlOption.BIND, parameters);
    }

    default public String shardTB(Object ... optionItems) {
        TableModel model = SqlBoxContextUtils.findTableModel(this.getClass(), (Object[])optionItems);
        ColumnModel col = model.getShardTableColumn();
        if (col == null || col.getShardTable() == null || col.getShardTable().length == 0) {
            throw new SqlBoxException("Not found ShardTable setting for '" + model.getEntityClass() + "'");
        }
        Object shardKey1 = ClassCacheUtils.readValueFromBeanField((Object)this, (String)col.getColumnName());
        return SqlBoxContextUtils.getShardedTB((SqlBoxContext)this.ctx(new Object[0]), (Object)model.getEntityClass(), (Object[])new Object[]{shardKey1});
    }

    default public SqlBoxContext shardDB(Object ... optionItems) {
        TableModel model = SqlBoxContextUtils.findTableModel(this.getClass(), (Object[])optionItems);
        ColumnModel col = model.getShardDatabaseColumn();
        if (col == null || col.getShardDatabase() == null || col.getShardDatabase().length == 0) {
            throw new SqlBoxException("Not found ShardTable setting for '" + model.getEntityClass() + "'");
        }
        Object shardKey1 = ClassCacheUtils.readValueFromBeanField((Object)this, (String)col.getColumnName());
        return SqlBoxContextUtils.getShardedDB((SqlBoxContext)this.ctx(new Object[0]), (Object)model.getEntityClass(), (Object[])new Object[]{shardKey1});
    }
}

