/*
 * Decompiled with CFR 0.152.
 */
package com.github.drinkjava2.jsqlbox;

import com.github.drinkjava2.jdbpro.SqlItem;
import com.github.drinkjava2.jdbpro.SqlOption;
import com.github.drinkjava2.jdialects.ArrayUtils;
import com.github.drinkjava2.jdialects.ClassCacheUtils;
import com.github.drinkjava2.jdialects.TableModelUtils;
import com.github.drinkjava2.jdialects.model.ColumnModel;
import com.github.drinkjava2.jdialects.model.TableModel;
import com.github.drinkjava2.jsqlbox.ActiveRecord;
import com.github.drinkjava2.jsqlbox.EntityType;
import com.github.drinkjava2.jsqlbox.SqlBoxContext;
import com.github.drinkjava2.jsqlbox.SqlBoxContextUtils;
import com.github.drinkjava2.jsqlbox.SqlBoxException;
import com.github.drinkjava2.jsqlbox.entitynet.EntityNet;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.dbutils.ResultSetHandler;

public interface ActiveEntity<T>
extends EntityType {
    default public void miscMethods__________________() {
    }

    default public SqlBoxContext ctx(Object ... optionItems) {
        for (Object item : optionItems) {
            if (item == null || !(item instanceof SqlBoxContext)) continue;
            return (SqlBoxContext)item;
        }
        SqlBoxException.assureNotNull((Object)SqlBoxContext.getGlobalSqlBoxContext(), (String[])new String[]{"No default global SqlBoxContext found, need use method SqlBoxContext.setGlobalSqlBoxContext() to set a global default SqlBoxContext instance at the beginning of appication."});
        return SqlBoxContext.getGlobalSqlBoxContext();
    }

    default public T putField(Object ... fieldAndValues) {
        for (int i = 0; i < fieldAndValues.length / 2; ++i) {
            String field = (String)fieldAndValues[i * 2];
            Object value = fieldAndValues[i * 2 + 1];
            Method writeMethod = ClassCacheUtils.getClassFieldWriteMethod(this.getClass(), (String)field);
            try {
                writeMethod.invoke((Object)this, value);
                continue;
            }
            catch (Exception e) {
                throw new SqlBoxException((Throwable)e);
            }
        }
        return (T)this;
    }

    default public T forFields(String ... fieldNames) {
        ActiveRecord.forFieldsOrTails.set(fieldNames);
        return (T)this;
    }

    default public T putValues(Object ... values) {
        String[] fields = (String[])ActiveRecord.forFieldsOrTails.get();
        if (values.length == 0 || fields == null || fields.length == 0) {
            throw new SqlBoxException("putValues fields or values can not be empty");
        }
        if (values.length != fields.length) {
            throw new SqlBoxException("putValues fields and values number not match");
        }
        for (int i = 0; i < fields.length; ++i) {
            Method writeMethod = ClassCacheUtils.getClassFieldWriteMethod(this.getClass(), (String)fields[i]);
            if (writeMethod == null) {
                throw new SqlBoxException("Not found writeMethod for '" + this.getClass() + "' class's method '" + fields[i] + "'");
            }
            try {
                writeMethod.invoke((Object)this, values[i]);
                continue;
            }
            catch (Exception e) {
                throw new SqlBoxException((Throwable)e);
            }
        }
        return (T)this;
    }

    default public SqlItem bind(Object ... parameters) {
        return new SqlItem(SqlOption.BIND, parameters);
    }

    default public String shardTB(Object ... optionItems) {
        TableModel model = SqlBoxContextUtils.findTableModel(this.getClass(), (Object[])optionItems);
        ColumnModel col = model.getShardTableColumn();
        if (col == null || col.getShardTable() == null || col.getShardTable().length == 0) {
            throw new SqlBoxException("Not found ShardTable setting for '" + model.getEntityClass() + "'");
        }
        Object shardKey1 = SqlBoxContextUtils.readValueFromBeanFieldOrTail((ColumnModel)col, (Object)this);
        return SqlBoxContextUtils.getShardedTB((SqlBoxContext)this.ctx(new Object[0]), (Object)model.getEntityClass(), (Object[])new Object[]{shardKey1});
    }

    default public SqlBoxContext shardDB(Object ... optionItems) {
        TableModel model = SqlBoxContextUtils.findTableModel(this.getClass(), (Object[])optionItems);
        ColumnModel col = model.getShardDatabaseColumn();
        if (col == null || col.getShardDatabase() == null || col.getShardDatabase().length == 0) {
            throw new SqlBoxException("Not found ShardTable setting for '" + model.getEntityClass() + "'");
        }
        Object shardKey1 = SqlBoxContextUtils.readValueFromBeanFieldOrTail((ColumnModel)col, (Object)this);
        return SqlBoxContextUtils.getShardedDB((SqlBoxContext)this.ctx(new Object[0]), (Object)model.getEntityClass(), (Object[])new Object[]{shardKey1});
    }

    default public Object[] shard(Object ... optionItems) {
        return new Object[]{this.shardTB(optionItems), this.shardDB(optionItems)};
    }

    public static Object[] insertThisClassIfNotHave(Object entity, Object ... optionItems) {
        Object[] items = optionItems;
        TableModel[] models = SqlBoxContextUtils.findAllModels((Object[])optionItems);
        if (models.length == 0) {
            throw new SqlBoxException("No TableMode found for entity.");
        }
        TableModel model = models[0];
        if (!entity.getClass().equals(model.getEntityClass())) {
            model = TableModelUtils.entity2ReadOnlyModel(entity.getClass());
            items = ArrayUtils.insertArray((Object)model, (Object[])items);
        }
        return items;
    }

    default public void crudMethods__________________() {
    }

    default public T insert(Object ... items) {
        return (T)this.ctx(items).eInsert((Object)this, items);
    }

    default public T update(Object ... items) {
        return (T)this.ctx(items).eUpdate((Object)this, items);
    }

    default public int updateTry(Object ... items) {
        return this.ctx(items).eUpdateTry((Object)this, items);
    }

    default public void delete(Object ... items) {
        this.ctx(items).eDelete((Object)this, items);
    }

    default public int deleteTry(Object ... items) {
        return this.ctx(items).eDeleteTry((Object)this, items);
    }

    default public void deleteById(Object id, Object ... items) {
        this.ctx(items).eDeleteById(this.getClass(), id, items);
    }

    default public int deleteByIdTry(Object id, Object ... items) {
        return this.ctx(items).eDeleteByIdTry(this.getClass(), id, items);
    }

    default public boolean exist(Object ... items) {
        return this.ctx(items).eExist((Object)this, items);
    }

    default public boolean existById(Object id, Object ... items) {
        return this.ctx(items).eExistById(this.getClass(), id, items);
    }

    default public int countAll(Object ... items) {
        return this.ctx(items).eCountAll(this.getClass(), items);
    }

    default public T load(Object ... items) {
        return (T)this.ctx(items).eLoad((Object)this, items);
    }

    default public int loadTry(Object ... items) {
        return this.ctx(items).eLoadTry((Object)this, items);
    }

    default public T loadById(Object id, Object ... items) {
        return (T)this.ctx(items).eLoadById(this.getClass(), id, items);
    }

    default public T loadByIdTry(Object id, Object ... items) {
        return (T)this.ctx(items).eLoadByIdTry(this.getClass(), id, items);
    }

    default public T loadBySQL(Object ... items) {
        return (T)this.ctx(items).eLoadBySQL(items);
    }

    default public List<T> findAll(Object ... items) {
        return this.ctx(items).eFindAll(this.getClass(), items);
    }

    default public List<T> findBySQL(Object ... items) {
        return this.ctx(items).eFindBySQL(new Object[]{this.getClass(), items});
    }

    default public List<T> findBySample(Object sampleBean, Object ... items) {
        return this.ctx(items).eFindBySample(sampleBean, items);
    }

    default public EntityNet autoNet(Class<?> ... entityClass) {
        return this.ctx(new Object[0]).autoNet((Class[])entityClass);
    }

    default public <E> E findRelatedOne(Object ... items) {
        Object[] newItems = ActiveEntity.insertThisClassIfNotHave(this, items);
        return (E)this.ctx(items).eFindRelatedOne((Object)this, newItems);
    }

    default public <E> List<E> findRelatedList(Object ... items) {
        Object[] newItems = ActiveEntity.insertThisClassIfNotHave(this, items);
        return this.ctx(items).eFindRelatedList((Object)this, newItems);
    }

    default public <E> Set<E> findRelatedSet(Object ... items) {
        Object[] newItems = ActiveEntity.insertThisClassIfNotHave(this, items);
        return this.ctx(items).eFindRelatedSet((Object)this, newItems);
    }

    default public <E> Map<Object, E> findRelatedMap(Object ... items) {
        Object[] newItems = ActiveEntity.insertThisClassIfNotHave(this, items);
        return this.ctx(items).eFindRelatedMap((Object)this, newItems);
    }

    default public <E> List<E> eFindAll(Class<E> entityClass, Object ... items) {
        return this.ctx(items).eFindAll(entityClass, items);
    }

    default public <E> List<E> eFindBySample(Object sampleBean, Object ... items) {
        return this.ctx(items).eFindBySample(sampleBean, items);
    }

    default public <E> List<E> eFindBySQL(Object ... items) {
        return this.ctx(items).eFindBySQL(items);
    }

    default public <E> E eInsert(E entity, Object ... items) {
        return (E)this.ctx(items).eInsert(entity, items);
    }

    default public <E> E eLoad(E entity, Object ... items) {
        return (E)this.ctx(items).eLoad(entity, items);
    }

    default public <E> E eLoadById(Class<E> entityClass, Object entityId, Object ... items) {
        return (E)this.ctx(items).eLoadById(entityClass, entityId, items);
    }

    default public <E> E eLoadByIdTry(Class<E> entityClass, Object entityId, Object ... items) {
        return (E)this.ctx(items).eLoadByIdTry(entityClass, entityId, items);
    }

    default public <E> E eUpdate(Object entity, Object ... items) {
        return (E)this.ctx(items).eUpdate(entity, items);
    }

    default public boolean eExist(Object entity, Object ... items) {
        return this.ctx(items).eExist(entity, items);
    }

    default public boolean eExistById(Class<?> entityClass, Object id, Object ... items) {
        return this.ctx(items).eExistById(entityClass, id, items);
    }

    default public int eCountAll(Class<?> entityClass, Object ... items) {
        return this.ctx(items).eCountAll(entityClass, items);
    }

    default public int eDeleteByIdTry(Class<?> entityClass, Object id, Object ... items) {
        return this.ctx(items).eDeleteByIdTry(entityClass, id, items);
    }

    default public int eDeleteTry(Object entity, Object ... items) {
        return this.ctx(items).eDeleteTry(entity, items);
    }

    default public int eLoadTry(Object entity, Object ... items) {
        return this.ctx(items).eLoadTry(entity, items);
    }

    default public int eUpdateTry(Object entity, Object ... items) {
        return this.ctx(items).eUpdateTry(entity, items);
    }

    default public void eDelete(Object entity, Object ... items) {
        this.ctx(items).eDelete(entity, items);
    }

    default public void eDeleteById(Class<?> entityClass, Object id, Object ... items) {
        this.ctx(items).eDeleteById(entityClass, id, items);
    }

    default public <E> E eFindRelatedOne(Object entity, Object ... items) {
        return (E)this.ctx(items).eFindRelatedOne(entity, items);
    }

    default public <E> List<E> eFindRelatedList(Object entityOrIterable, Object ... items) {
        return this.ctx(items).eFindRelatedList(entityOrIterable, items);
    }

    default public <E> Set<E> eFindRelatedSet(Object entity, Object ... items) {
        return this.ctx(items).eFindRelatedSet(entity, items);
    }

    default public <E> Map<Object, E> eFindRelatedMap(Object entity, Object ... items) {
        return this.ctx(items).eFindRelatedMap(entity, items);
    }

    default public <E> E pQuery(Object ... items) {
        return (E)this.ctx(items).pQuery(items);
    }

    default public <E> E pQueryForObject(Object ... items) {
        return (E)this.ctx(items).pQueryForObject(items);
    }

    default public long pQueryForLongValue(Object ... items) {
        return this.ctx(items).pQueryForLongValue(items);
    }

    default public String pQueryForString(Object ... items) {
        return this.ctx(items).pQueryForString(items);
    }

    default public List<Map<String, Object>> pQueryForMapList(Object ... items) {
        return this.ctx(items).pQueryForMapList(items);
    }

    default public int pUpdate(Object ... items) {
        return this.ctx(items).pUpdate(items);
    }

    default public <E> E pInsert(Object ... items) {
        return (E)this.ctx(items).pInsert(items);
    }

    default public <E> E pExecute(Object ... items) {
        return (E)this.ctx(items).pExecute(items);
    }

    default public <E> List<E> pQueryForEntityList(Object ... items) {
        return this.ctx(items).pQueryForEntityList(items);
    }

    default public <E> E iQuery(Object ... items) {
        return (E)this.ctx(items).iQuery(items);
    }

    default public <E> E iQueryForObject(Object ... items) {
        return (E)this.ctx(items).iQueryForObject(items);
    }

    default public long iQueryForLongValue(Object ... items) {
        return this.ctx(items).iQueryForLongValue(items);
    }

    default public String iQueryForString(Object ... items) {
        return this.ctx(items).iQueryForString(items);
    }

    default public List<Map<String, Object>> iQueryForMapList(Object ... items) {
        return this.ctx(items).iQueryForMapList(items);
    }

    default public int iUpdate(Object ... items) {
        return this.ctx(items).iUpdate(items);
    }

    default public <E> E iInsert(Object ... items) {
        return (E)this.ctx(items).iInsert(items);
    }

    default public <E> E iExecute(Object ... items) {
        return (E)this.ctx(items).iExecute(items);
    }

    default public <E> List<E> iQueryForEntityList(Object ... items) {
        return this.ctx(items).iQueryForEntityList(items);
    }

    default public <E> E nQuery(Connection conn, ResultSetHandler<E> rsh, String sql, Object ... items) {
        return (E)this.ctx(items).nQuery(conn, rsh, sql, items);
    }

    default public <E> E nQueryForObject(Connection conn, String sql, Object ... items) {
        return (E)this.ctx(items).nQueryForObject(conn, sql, items);
    }

    default public String nQueryForString(Connection conn, String sql, Object ... items) {
        return this.ctx(items).nQueryForString(conn, sql, items);
    }

    default public long nQueryForLongValue(Connection conn, String sql, Object ... items) {
        return this.ctx(items).nQueryForLongValue(conn, sql, items);
    }

    default public List<Map<String, Object>> nQueryForMapList(Connection conn, String sql, Object ... items) {
        return this.ctx(items).nQueryForMapList(conn, sql, items);
    }

    default public int nUpdate(Connection conn, String sql, Object ... items) {
        return this.ctx(items).nUpdate(conn, sql, items);
    }

    default public <E> E nInsert(Connection conn, ResultSetHandler<E> rsh, String sql, Object ... items) {
        return (E)this.ctx(items).nInsert(conn, rsh, sql, items);
    }

    default public int nExecute(Connection conn, String sql, Object ... items) {
        return this.ctx(items).nExecute(conn, sql, items);
    }

    default public <E> List<E> nExecute(Connection conn, ResultSetHandler<E> rsh, String sql, Object ... items) {
        return this.ctx(items).nExecute(conn, rsh, sql, items);
    }

    default public <E> E nQuery(ResultSetHandler<E> rsh, String sql, Object ... items) {
        return (E)this.ctx(items).nQuery(rsh, sql, items);
    }

    default public <E> E nQueryForObject(String sql, Object ... items) {
        return (E)this.ctx(items).nQueryForObject(sql, items);
    }

    default public String nQueryForString(String sql, Object ... items) {
        return this.ctx(items).nQueryForString(sql, items);
    }

    default public long nQueryForLongValue(String sql, Object ... items) {
        return this.ctx(items).nQueryForLongValue(sql, items);
    }

    default public List<Map<String, Object>> nQueryForMapList(String sql, Object ... items) {
        return this.ctx(items).nQueryForMapList(sql, items);
    }

    default public int nUpdate(String sql, Object ... items) {
        return this.ctx(items).nUpdate(sql, items);
    }

    default public <E> E nInsert(ResultSetHandler rsh, String sql, Object ... items) {
        return (E)this.ctx(items).nInsert(rsh, sql, items);
    }

    default public int nExecute(String sql, Object ... items) {
        return this.ctx(items).nExecute(sql, items);
    }

    default public <E> List<E> nExecute(ResultSetHandler rsh, String sql, Object ... items) {
        return this.ctx(items).nExecute(rsh, sql, items);
    }

    default public <E> E tQuery(Object ... items) {
        return (E)this.ctx(items).tQuery(items);
    }

    default public <E> E tQueryForObject(Object ... items) {
        return (E)this.ctx(items).tQueryForObject(items);
    }

    default public long tQueryForLongValue(Object ... items) {
        return this.ctx(items).tQueryForLongValue(items);
    }

    default public String tQueryForString(Object ... items) {
        return this.ctx(items).tQueryForString(items);
    }

    default public List<Map<String, Object>> tQueryForMapList(Object ... items) {
        return this.ctx(items).tQueryForMapList(items);
    }

    default public int tUpdate(Object ... items) {
        return this.ctx(items).tUpdate(items);
    }

    default public <E> E tInsert(Object ... items) {
        return (E)this.ctx(items).tInsert(items);
    }

    default public <E> E tExecute(Object ... items) {
        return (E)this.ctx(items).tExecute(items);
    }

    default public <E> List<E> tQueryForEntityList(Class<E> entityClass, Object ... items) {
        return this.ctx(items).tQueryForEntityList(new Object[]{entityClass, items});
    }
}

