/*
 * Decompiled with CFR 0.152.
 */
package com.github.hetianyi.plugins.generator.mvc;

import cn.hutool.core.io.FileUtil;
import com.github.hetianyi.boot.ready.common.util.StringUtil;
import com.github.hetianyi.plugins.generator.common.BaseMojo;
import com.github.hetianyi.plugins.generator.common.ProfileProperties;
import com.github.hetianyi.plugins.generator.common.TemplateConfig;
import com.github.hetianyi.plugins.generator.common.TemplateType;
import com.github.hetianyi.plugins.generator.common.util.GenerateUtil;
import com.github.hetianyi.plugins.generator.common.util.InflectorUtil;
import com.github.hetianyi.plugins.generator.pojo.entity.TableColumn;
import com.github.hetianyi.plugins.generator.pojo.generator.ClassGenerator;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.StringJoiner;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mojo(name="generate-mvc", defaultPhase=LifecyclePhase.COMPILE)
public class MvcMojo
extends BaseMojo {
    private static final Logger log = LoggerFactory.getLogger(MvcMojo.class);

    @Override
    protected void runProfile(ProfileProperties profile) throws Exception {
        super.runProfile(profile);
        if (StringUtil.isNullOrEmpty((String)profile.getMvcTemplateDir())) {
            this.getLog().info((CharSequence)("\u672a\u914d\u7f6emvcTemplateDir, profile: " + profile.getName() + "\u5c06\u7ec8\u6b62\u6267\u884c"));
            return;
        }
        Map<String, ClassGenerator> map = GenerateUtil.resolveTables(profile);
        List<File> templateTypeFiles = this.detectTemplateFile(profile);
        for (Map.Entry<String, ClassGenerator> entry : map.entrySet()) {
            this.findReplaceCopy(templateTypeFiles, entry);
        }
    }

    private List<File> detectTemplateFile(ProfileProperties profile) throws IOException {
        LinkedList<File> result = new LinkedList<File>();
        String mvcTemplateDir = profile.getMvcTemplateDir();
        Path templateRootPath = Paths.get(mvcTemplateDir, new String[0]);
        if (!Files.exists(templateRootPath, new LinkOption[0])) {
            throw new RuntimeException("\u6a21\u7248\u76ee\u5f55\u4e0d\u5b58\u5728: " + templateRootPath);
        }
        log.debug("\u904d\u5386\u76ee\u5f55\uff1a" + templateRootPath);
        Files.walk(templateRootPath, new FileVisitOption[0]).forEach(v -> {
            File file = v.toFile();
            if (!file.isDirectory()) {
                String content = FileUtil.readUtf8String((File)file);
                for (Map.Entry<TemplateType, String> entry : TemplateConfig.templateCommentMarker.entrySet()) {
                    if (!content.contains(entry.getValue())) continue;
                    result.add(file);
                    log.debug("\u6a21\u7248\u6587\u4ef6 -> " + v.toFile().getAbsolutePath());
                }
            }
        });
        return result;
    }

    private void findReplaceCopy(List<File> templateTypeFiles, Map.Entry<String, ClassGenerator> entry) {
        String pojoClassName = entry.getKey();
        log.info("\u521b\u5efa\u6a21\u7248\u590d\u5236: " + pojoClassName);
        ClassGenerator generator = entry.getValue();
        String lowerObjectName = generator.getLowerObjectName();
        String upperObjectName = generator.getUpperObjectName();
        String entityName = Optional.ofNullable(generator.getTabDef().getComment()).orElse("").replace("\r\n", "\n").replace("\n", " ").replace("\u8868", "");
        for (File e : templateTypeFiles) {
            File templateFileDir = e.getParentFile();
            String templateFileName = e.getName();
            String copyFileName = templateFileName.replace("Example", upperObjectName);
            String templateContent = FileUtil.readUtf8String((File)e);
            StringJoiner sJoiner = new StringJoiner("`, `");
            generator.getTabDef().getColumns().forEach(v -> sJoiner.add(v.getName()));
            TableColumn idColumn = generator.getTabDef().getColumns().stream().filter(v -> v.isId()).findFirst().orElse(null);
            String allFields = "`" + sJoiner + "`";
            templateContent = templateContent.replace("// #MvcTemplate#\r\n", "").replace("// #MvcTemplate#\n", "").replace("<!--#MvcTemplate#-->\r\n", "").replace("<!--#MvcTemplate#-->\n", "").replace("#MvcTemplate#\r\n", "").replace("#MvcTemplate#\n", "").replace("#MvcTemplate#", "").replaceAll("/\\*\\s*#allFieldsStart#\\s*\\*/.*/\\*\\s*#allFieldsEnd#\\s*\\*/", allFields).replaceAll("/\\*\\s*#idFieldStart#\\s*\\*/.*/\\*\\s*#idFieldEnd#\\s*\\*/", null == idColumn ? "`id`" : "`" + idColumn.getName() + "`");
            templateContent = templateContent.replace("examples", InflectorUtil.getInstance().pluralize(lowerObjectName)).replace("Examples", InflectorUtil.getInstance().pluralize(upperObjectName)).replace("Example", upperObjectName).replace("example", lowerObjectName).replace("\u793a\u4f8b", entityName);
            File targetFile = new File(templateFileDir, copyFileName);
            FileUtil.writeUtf8String((String)templateContent, (File)targetFile);
        }
    }
}

