/*
 * Decompiled with CFR 0.152.
 */
package com.github.hetianyi.plugins.generator.common.util;

import cn.hutool.db.Db;
import com.github.hetianyi.boot.ready.common.util.CollectionUtil;
import com.github.hetianyi.boot.ready.common.util.StringUtil;
import com.github.hetianyi.plugins.generator.common.DbConfigurationProperties;
import com.github.hetianyi.plugins.generator.common.DbType;
import com.github.hetianyi.plugins.generator.common.InstanceConfig;
import com.github.hetianyi.plugins.generator.common.ProfileProperties;
import com.github.hetianyi.plugins.generator.pojo.entity.TableColumn;
import com.github.hetianyi.plugins.generator.pojo.entity.TableDefinition;
import com.github.hetianyi.plugins.generator.pojo.generator.ClassGenerator;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenerateUtil {
    private static final Logger log = LoggerFactory.getLogger(GenerateUtil.class);
    public static final ThreadLocal<ProfileProperties> currentProfile = new ThreadLocal();
    private static final ThreadLocal<DbType> databaseType = new ThreadLocal();

    public static Map<String, ClassGenerator> resolveTables(ProfileProperties profile) throws Exception {
        currentProfile.set(profile);
        if ("postgresql".equalsIgnoreCase(InstanceConfig.getDbProperties().getType())) {
            databaseType.set(DbType.POSTGRESQL);
        } else {
            databaseType.set(DbType.MYSQL);
        }
        Db db = InstanceConfig.getDb();
        DbConfigurationProperties dbProperties = InstanceConfig.getDbProperties();
        List query = databaseType.get() == DbType.POSTGRESQL ? db.query("select a.relname as TABLE_NAME, b.description as TABLE_COMMENT from pg_class a left join ( select * from pg_description where objsubid = 0 ) b on A.oid = b.objoid where a.relname in ( select tablename from pg_tables where schemaname = ? )  order by a.relname asc", new Object[]{dbProperties.getSchema()}) : db.query("select TABLE_NAME, TABLE_TYPE, TABLE_COMMENT from information_schema.`TABLES` a where a.TABLE_SCHEMA = ?", new Object[]{dbProperties.getDbName()});
        LinkedList tabDefs = new LinkedList();
        query.forEach(v -> {
            if (!CollectionUtil.isNullOrEmpty(profile.getExcludeTables()) && profile.getExcludeTables().contains((String)v.get((Object)"TABLE_NAME"))) {
                return;
            }
            if (!CollectionUtil.isNullOrEmpty(profile.getIncludeTables()) && profile.getIncludeTables().contains((String)v.get((Object)"TABLE_NAME"))) {
                tabDefs.add(TableDefinition.builder().name((String)v.get((Object)"TABLE_NAME")).type((String)v.get((Object)"TABLE_TYPE")).comment((String)v.get((Object)"TABLE_COMMENT")).build());
            } else {
                tabDefs.add(TableDefinition.builder().name((String)v.get((Object)"TABLE_NAME")).type((String)v.get((Object)"TABLE_TYPE")).comment((String)v.get((Object)"TABLE_COMMENT")).build());
            }
        });
        if (CollectionUtil.isNullOrEmpty(tabDefs)) {
            log.info("\u6ca1\u6709\u9700\u8981\u5bfc\u51fa\u7684\u8868");
            return ImmutableMap.of();
        }
        HashMap<String, ClassGenerator> resultMap = new HashMap<String, ClassGenerator>();
        for (TableDefinition tabDef : tabDefs) {
            GenerateUtil.getTableColumnDef(tabDef);
            ClassGenerator generator = GenerateUtil.getClassGenerator(tabDef);
            if (resultMap.containsKey(generator.getClassName())) {
                throw new RuntimeException("\u7c7b\u540d\u91cd\u590d: " + generator.getClassName());
            }
            resultMap.put(generator.getClassName(), generator);
        }
        if (StringUtil.isNullOrEmptyTrimed((String)currentProfile.get().getMvcTemplateDir())) {
            GenerateUtil.createPackageDir();
        }
        return resultMap;
    }

    public static void getTableColumnDef(TableDefinition td) throws Exception {
        DbConfigurationProperties dbProperties = InstanceConfig.getDbProperties();
        Db db = InstanceConfig.getDb();
        List result = databaseType.get() == DbType.POSTGRESQL ? db.query("SELECT\n\tordinal_position AS ORDINAL_POSITION,\n\tCOLUMN_NAME AS COLUMN_NAME,\n\tdata_type AS DATA_TYPE1,\n\tudt_name as DATA_TYPE,\n\tCOALESCE ( character_maximum_length, numeric_precision,- 1 ) AS LENGTH,\n\tnumeric_scale AS SCALE,\nCASE\n\t\tis_nullable \n\t\tWHEN 'NO' THEN\n\t\t0 ELSE 1 \n\tEND AS CanNull,\n\tcolumn_default AS EXTRA,\nCASE\n\t\t\n\t\tWHEN POSITION ( 'nextval' IN column_default ) > 0 THEN\n\t\t1 ELSE 0 \n\tEND AS IsIdentity,\nCASE\n\t\t\n\t\tWHEN b.pk_name IS NULL THEN\n\t\t'' ELSE 'PRI' \n\tEND AS COLUMN_KEY,\n\tC.DeText as COLUMN_COMMENT \nFROM\n\tinformation_schema.\n\tCOLUMNS LEFT JOIN (\n\tSELECT\n\t\tpg_attr.attname AS colname,\n\t\tpg_constraint.conname AS pk_name \n\tFROM\n\t\tpg_constraint\n\t\tINNER JOIN pg_class ON pg_constraint.conrelid = pg_class.oid\n\t\tINNER JOIN pg_attribute pg_attr ON pg_attr.attrelid = pg_class.oid \n\t\tAND pg_attr.attnum = pg_constraint.conkey [ 1 ]\n\t\tINNER JOIN pg_type ON pg_type.oid = pg_attr.atttypid \n\tWHERE\n\t\tpg_class.relname = ? \n\t\tAND pg_constraint.contype = 'p' \n\t) b ON b.colname = information_schema.COLUMNS.\n\tCOLUMN_NAME LEFT JOIN (\n\tSELECT\n\t\tattname,\n\t\tdescription AS DeText \n\tFROM\n\t\tpg_class\n\t\tLEFT JOIN pg_attribute pg_attr ON pg_attr.attrelid = pg_class.oid\n\t\tLEFT JOIN pg_description pg_desc ON pg_desc.objoid = pg_attr.attrelid \n\t\tAND pg_desc.objsubid = pg_attr.attnum \n\tWHERE\n\t\tpg_attr.attnum > 0 \n\t\tAND pg_attr.attrelid = pg_class.oid \n\t\tAND pg_class.relname = ? \n\t) C ON C.attname = information_schema.COLUMNS.COLUMN_NAME \nWHERE\n\ttable_schema = ? \n\tand table_name = ? \nORDER BY\n\tordinal_position ASC", new Object[]{td.getName(), td.getName(), dbProperties.getSchema(), td.getName()}) : db.query("select a.ORDINAL_POSITION, a.COLUMN_NAME, a.DATA_TYPE, a.COLUMN_COMMENT, a.COLUMN_KEY, a.EXTRA from information_schema.`COLUMNS` a where a.TABLE_SCHEMA=? and a.TABLE_NAME = ? order by a.ORDINAL_POSITION", new Object[]{dbProperties.getDbName(), td.getName()});
        LinkedList<TableColumn> fields = new LinkedList<TableColumn>();
        result.forEach(c -> {
            String extra = Optional.ofNullable((String)c.get((Object)"EXTRA")).orElse("");
            fields.add(TableColumn.builder().position(Integer.valueOf(c.get((Object)"ORDINAL_POSITION").toString())).name((String)c.get((Object)"COLUMN_NAME")).type((String)c.get((Object)"DATA_TYPE")).comment((String)c.get((Object)"COLUMN_COMMENT")).id(Optional.ofNullable((String)c.get((Object)"COLUMN_KEY")).orElse("").contains("PRI")).autoIncrement(extra.contains("auto_increment") || extra.contains("nextval(")).build());
        });
        td.setColumns(fields);
    }

    public static ClassGenerator getClassGenerator(TableDefinition tabDef) {
        return ClassGenerator.from(tabDef, currentProfile.get()).generateStructure();
    }

    public static String removePrefixOrSuffix(String name) {
        name = name.toLowerCase();
        Set<String> ignorePrefix = currentProfile.get().getIgnorePrefixes();
        Set<String> ignoreSuffix = currentProfile.get().getIgnoreSuffixes();
        if (!CollectionUtil.isNullOrEmpty(ignorePrefix)) {
            for (String prefix : ignorePrefix) {
                if (StringUtil.isNullOrEmptyTrimed((String)prefix) || !name.startsWith(prefix.toLowerCase())) continue;
                name = name.substring(prefix.length());
            }
        }
        if (!CollectionUtil.isNullOrEmpty(ignoreSuffix)) {
            for (String suffix : ignoreSuffix) {
                if (StringUtil.isNullOrEmptyTrimed((String)suffix) || !name.endsWith(suffix.toLowerCase())) continue;
                name = name.substring(0, name.length() - suffix.length());
            }
        }
        return name;
    }

    public static String camel(String name, boolean isTable) {
        name = name.toLowerCase();
        Pattern pattern = Pattern.compile("[-_]+([^_^-])");
        Matcher matcher = pattern.matcher(name);
        StringBuilder sb = new StringBuilder();
        int lastEnd = 0;
        while (matcher.find()) {
            String validContent = matcher.group(1);
            int start = matcher.start();
            int end = matcher.end();
            sb.append(name, lastEnd, start);
            sb.append(validContent.toUpperCase());
            lastEnd = end;
        }
        sb.append(name.substring(lastEnd));
        String ret = sb.toString();
        return (isTable ? ret.substring(0, 1).toUpperCase() : ret.substring(0, 1).toLowerCase()) + ret.substring(1);
    }

    public static void createPackageDir(String packageName) throws IOException {
        String[] paths = packageName.split("\\.");
        Path pkgDir = Paths.get(currentProfile.get().getOutputDir(), paths);
        log.info("\u521b\u5efa\u7a0b\u5e8f\u5305\u8f93\u51fa\u76ee\u5f55: {}", (Object)pkgDir);
        Files.createDirectories(pkgDir, new FileAttribute[0]);
    }

    public static void createPackageDir() throws IOException {
        String packageName = currentProfile.get().getPackageName();
        String[] paths = packageName.split("\\.");
        Path pkgDir = Paths.get(currentProfile.get().getOutputDir(), paths);
        log.info("\u521b\u5efa\u7a0b\u5e8f\u5305\u8f93\u51fa\u76ee\u5f55: {}", (Object)pkgDir);
        Files.createDirectories(pkgDir, new FileAttribute[0]);
    }
}

