/*
 * Decompiled with CFR 0.152.
 */
package com.github.hetianyi.plugins.generator.pojo;

import com.github.hetianyi.boot.ready.common.util.StringUtil;
import com.github.hetianyi.plugins.generator.common.BaseMojo;
import com.github.hetianyi.plugins.generator.common.ProfileProperties;
import com.github.hetianyi.plugins.generator.common.util.GenerateUtil;
import com.github.hetianyi.plugins.generator.pojo.generator.ClassGenerator;
import java.io.File;
import java.io.FileOutputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Map;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;

@Mojo(name="generate-pojo", defaultPhase=LifecyclePhase.COMPILE)
public class EntityMojo
extends BaseMojo {
    @Override
    protected void runProfile(ProfileProperties profile) throws Exception {
        super.runProfile(profile);
        if (!StringUtil.isNullOrEmpty((String)profile.getMvcTemplateDir())) {
            this.getLog().info((CharSequence)("\u5df2\u914d\u7f6emvcTemplateDir, mvcTemplateDir\u53ea\u80fd\u5728goal: generate-mvc\u4e2d\u8fd0\u884c, \u56e0\u6b64profile: " + profile.getName() + "\u5c06\u7ec8\u6b62\u6267\u884c"));
            return;
        }
        Map<String, ClassGenerator> map = GenerateUtil.resolveTables(profile);
        for (Map.Entry<String, ClassGenerator> entry : map.entrySet()) {
            this.writeSource(profile, entry);
        }
    }

    private void writeSource(ProfileProperties profile, Map.Entry<String, ClassGenerator> entry) throws Exception {
        String className = entry.getKey();
        ClassGenerator generator = entry.getValue();
        String packageName = profile.getPackageName();
        LinkedList<String> paths = new LinkedList<String>(Arrays.asList(packageName.split("\\.")));
        paths.add(className + ".java");
        Path srcFilePath = Paths.get(profile.getOutputDir(), paths.toArray(new String[0]));
        File srcFile = srcFilePath.toFile();
        try (FileOutputStream fileOutputStream = new FileOutputStream(srcFile, false);){
            fileOutputStream.write(generator.applyFeatures().generateContent().getBytes());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

