/*
 * Decompiled with CFR 0.152.
 */
package com.github.hetianyi.plugins.generator.pojo.generator.feature.extend.mybatis;

import com.github.hetianyi.plugins.generator.common.SlotType;
import com.github.hetianyi.plugins.generator.pojo.entity.TableColumn;
import com.github.hetianyi.plugins.generator.pojo.generator.feature.CustomFeature;
import com.github.hetianyi.plugins.generator.pojo.generator.slot.CodeSlot;
import com.github.hetianyi.plugins.generator.pojo.generator.slot.IndentSlot;
import com.google.common.collect.ImmutableList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MyBatisPlusFieldAnnotationFeature
extends CustomFeature {
    private static final Logger log = LoggerFactory.getLogger(MyBatisPlusFieldAnnotationFeature.class);

    public MyBatisPlusFieldAnnotationFeature() {
        super(SlotType.FIELD_HEAD, CustomFeature.InsertLocation.AFTER, (s, g) -> {
            TableColumn column = (TableColumn)s.getAttribute("column");
            if (column.isId()) {
                g.getImports().add("com.baomidou.mybatisplus.annotation.TableId");
                g.getImports().add("com.baomidou.mybatisplus.annotation.IdType");
                return ImmutableList.of((Object)IndentSlot.getInstance(), (Object)CodeSlot.of("@TableId(value = \"", column.getName(), "\", type = IdType.", column.isAutoIncrement() ? "AUTO" : "INPUT", ")\n"));
            }
            g.getImports().add("com.baomidou.mybatisplus.annotation.TableField");
            return ImmutableList.of((Object)IndentSlot.getInstance(), (Object)CodeSlot.of("@TableField(\"", column.getName(), "\")\n"));
        });
        log.debug("\u5e94\u7528Feature -> MyBatisPlusFieldAnnotationFeature");
    }
}

