/*
 * Decompiled with CFR 0.152.
 */
package com.github.hetianyi.plugins.generator.common.util;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class InflectorUtil {
    private static final Pattern UNDERSCORE_PATTERN_1 = Pattern.compile("([A-Z]+)([A-Z][a-z])");
    private static final Pattern UNDERSCORE_PATTERN_2 = Pattern.compile("([a-z\\d])([A-Z])");
    private static List<RuleAndReplacement> plurals = new ArrayList<RuleAndReplacement>();
    private static List<RuleAndReplacement> singulars = new ArrayList<RuleAndReplacement>();
    private static List<String> uncountables = new ArrayList<String>();
    private static InflectorUtil instance;

    private InflectorUtil() {
        this.initialize();
    }

    private void initialize() {
        InflectorUtil.plural("$", "s");
        InflectorUtil.plural("s$", "s");
        InflectorUtil.plural("(ax|test)is$", "$1es");
        InflectorUtil.plural("(octop|vir)us$", "$1i");
        InflectorUtil.plural("(alias|status)$", "$1es");
        InflectorUtil.plural("(bu)s$", "$1es");
        InflectorUtil.plural("(buffal|tomat)o$", "$1oes");
        InflectorUtil.plural("([ti])um$", "$1a");
        InflectorUtil.plural("sis$", "ses");
        InflectorUtil.plural("(?:([^f])fe|([lr])f)$", "$1$2ves");
        InflectorUtil.plural("(hive)$", "$1s");
        InflectorUtil.plural("([^aeiouy]|qu)y$", "$1ies");
        InflectorUtil.plural("([^aeiouy]|qu)ies$", "$1y");
        InflectorUtil.plural("(x|ch|ss|sh)$", "$1es");
        InflectorUtil.plural("(matr|vert|ind)ix|ex$", "$1ices");
        InflectorUtil.plural("([m|l])ouse$", "$1ice");
        InflectorUtil.plural("(ox)$", "$1es");
        InflectorUtil.plural("(quiz)$", "$1zes");
        InflectorUtil.singular("s$", "");
        InflectorUtil.singular("(n)ews$", "$1ews");
        InflectorUtil.singular("([ti])a$", "$1um");
        InflectorUtil.singular("((a)naly|(b)a|(d)iagno|(p)arenthe|(p)rogno|(s)ynop|(t)he)ses$", "$1$2sis");
        InflectorUtil.singular("(^analy)ses$", "$1sis");
        InflectorUtil.singular("([^f])ves$", "$1fe");
        InflectorUtil.singular("(hive)s$", "$1");
        InflectorUtil.singular("(tive)s$", "$1");
        InflectorUtil.singular("([lr])ves$", "$1f");
        InflectorUtil.singular("([^aeiouy]|qu)ies$", "$1y");
        InflectorUtil.singular("(s)eries$", "$1eries");
        InflectorUtil.singular("(m)ovies$", "$1ovie");
        InflectorUtil.singular("(x|ch|ss|sh)es$", "$1");
        InflectorUtil.singular("([m|l])ice$", "$1ouse");
        InflectorUtil.singular("(bus)es$", "$1");
        InflectorUtil.singular("(o)es$", "$1");
        InflectorUtil.singular("(shoe)s$", "$1");
        InflectorUtil.singular("(cris|ax|test)es$", "$1is");
        InflectorUtil.singular("([octop|vir])i$", "$1us");
        InflectorUtil.singular("(alias|status)es$", "$1");
        InflectorUtil.singular("^(ox)es", "$1");
        InflectorUtil.singular("(vert|ind)ices$", "$1ex");
        InflectorUtil.singular("(matr)ices$", "$1ix");
        InflectorUtil.singular("(quiz)zes$", "$1");
        InflectorUtil.irregular("person", "people");
        InflectorUtil.irregular("man", "men");
        InflectorUtil.irregular("child", "children");
        InflectorUtil.irregular("sex", "sexes");
        InflectorUtil.irregular("move", "moves");
        InflectorUtil.uncountable("equipment", "information", "rice", "money", "species", "series", "fish", "sheep");
    }

    public static InflectorUtil getInstance() {
        if (instance == null) {
            instance = new InflectorUtil();
        }
        return instance;
    }

    public String underscore(String camelCasedWord) {
        String underscoredWord = UNDERSCORE_PATTERN_1.matcher(camelCasedWord).replaceAll("$1_$2");
        underscoredWord = UNDERSCORE_PATTERN_2.matcher(underscoredWord).replaceAll("$1_$2");
        underscoredWord = underscoredWord.replace('-', '_').toLowerCase();
        return underscoredWord;
    }

    public String pluralize(String word) {
        if (uncountables.contains(word.toLowerCase())) {
            return word;
        }
        return this.replaceWithFirstRule(word, plurals);
    }

    public String singularize(String word) {
        if (uncountables.contains(word.toLowerCase())) {
            return word;
        }
        return this.replaceWithFirstRule(word, singulars);
    }

    private String replaceWithFirstRule(String word, List<RuleAndReplacement> ruleAndReplacements) {
        for (RuleAndReplacement rar : ruleAndReplacements) {
            String rule = rar.getRule();
            String replacement = rar.getReplacement();
            Matcher matcher = Pattern.compile(rule, 2).matcher(word);
            if (!matcher.find()) continue;
            return matcher.replaceAll(replacement);
        }
        return word;
    }

    public String tableize(String className) {
        return this.pluralize(this.underscore(className));
    }

    public String tableize(Class<?> klass) {
        String className = klass.getName().replace(klass.getPackage().getName() + ".", "");
        return this.tableize(className);
    }

    public static void plural(String rule, String replacement) {
        plurals.add(0, new RuleAndReplacement(rule, replacement));
    }

    public static void singular(String rule, String replacement) {
        singulars.add(0, new RuleAndReplacement(rule, replacement));
    }

    public static void irregular(String singular, String plural) {
        InflectorUtil.plural(singular, plural);
        InflectorUtil.singular(plural, singular);
    }

    public static void uncountable(String ... words) {
        for (String word : words) {
            uncountables.add(word);
        }
    }

    public static void main(String[] args) {
        System.out.println(InflectorUtil.getInstance().pluralize("water"));
        System.out.println(InflectorUtil.getInstance().pluralize("box"));
        System.out.println(InflectorUtil.getInstance().pluralize("tomato"));
        System.out.println(InflectorUtil.getInstance().pluralize("activity"));
        System.out.println(InflectorUtil.getInstance().pluralize("Activity"));
        System.out.println(InflectorUtil.getInstance().singularize("apples"));
        System.out.println(InflectorUtil.getInstance().singularize("Activities"));
    }

    private static class RuleAndReplacement {
        private String rule;
        private String replacement;

        public RuleAndReplacement(String rule, String replacement) {
            this.rule = rule;
            this.replacement = replacement;
        }

        public String getReplacement() {
            return this.replacement;
        }

        public void setReplacement(String replacement) {
            this.replacement = replacement;
        }

        public String getRule() {
            return this.rule;
        }

        public void setRule(String rule) {
            this.rule = rule;
        }
    }
}

